/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.http;

import com.af.v4.system.common.plugins.http.BaseHttpPoolUtil;
import com.af.v4.system.common.plugins.http.HttpClientConfig;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAsyncConnectionPoolUtil
extends BaseHttpPoolUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpAsyncConnectionPoolUtil.class);
    private static final Object SYNC_LOCK = new Object();
    private static volatile CloseableHttpAsyncClient httpClient;

    public static CloseableHttpAsyncClient getHttpClient(DefaultClientTlsStrategy sslSocketFactory) {
        return HttpAsyncConnectionPoolUtil.createHttpClient(sslSocketFactory);
    }

    private static CloseableHttpAsyncClient createHttpClient() {
        return HttpAsyncConnectionPoolUtil.createHttpClient(null);
    }

    private static CloseableHttpAsyncClient createHttpClient(DefaultClientTlsStrategy sslSocketFactory) {
        if (sslSocketFactory == null) {
            logger.debug("\u521b\u5efaHTTP\u5f02\u6b65\u5ba2\u6237\u7aef\u4f1a\u8bdd");
            try {
                sslSocketFactory = new DefaultClientTlsStrategy(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        } else {
            logger.debug("\u521b\u5efahttps\u5f02\u6b65\u5ba2\u6237\u7aef\u4f1a\u8bdd");
        }
        Registry registry = RegistryBuilder.create().register("https", (Object)sslSocketFactory).build();
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors() * 2).setSoKeepAlive(true).build();
        PoolingAsyncClientConnectionManager manager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy((TlsStrategy)registry.lookup("https")).build();
        manager.setMaxTotal(HttpClientConfig.HTTP_MAX_POOL_SIZE.intValue());
        manager.setDefaultMaxPerRoute(HttpClientConfig.HTTP_MAX_POOL_SIZE.intValue());
        return HttpAsyncClients.custom().setIOReactorConfig(ioReactorConfig).setConnectionManager((AsyncClientConnectionManager)manager).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpAsyncClient getHttpClient() {
        if (httpClient == null) {
            Object object = SYNC_LOCK;
            synchronized (object) {
                if (httpClient == null) {
                    httpClient = HttpAsyncConnectionPoolUtil.createHttpClient();
                }
            }
        }
        httpClient.start();
        return httpClient;
    }

    public static void request(String value, String headersStr, HttpClientConfig config, SimpleHttpRequest base, CloseableHttpAsyncClient httpClient, FutureCallback<SimpleHttpResponse> futureCallback) {
        logger.info("\u5f02\u6b65\u8bf7\u6c42\u5730\u5740\uff1a" + base.getScheme() + "://" + base.getAuthority() + base.getPath());
        if (httpClient == null) {
            httpClient = HttpAsyncConnectionPoolUtil.getHttpClient();
        }
        if (futureCallback == null) {
            futureCallback = new InnerAsyncResponse();
        }
        HttpAsyncConnectionPoolUtil.setRequestConfig(config, (HttpRequest)base);
        HttpAsyncConnectionPoolUtil.setHeaders((HttpRequest)base, headersStr);
        if (base.getBody() == null) {
            HttpAsyncConnectionPoolUtil.setBody((HttpRequest)base, value);
        }
        httpClient.execute(base, (FutureCallback)futureCallback);
    }

    public static class InnerAsyncResponse
    implements FutureCallback<SimpleHttpResponse> {
        final long begin = System.currentTimeMillis();

        public void completed(SimpleHttpResponse response) {
            String result = null;
            try {
                result = BaseHttpPoolUtil.getResponseData(this.begin, (HttpResponse)response);
            }
            catch (Exception e) {
                this.failed(e);
            }
            logger.info("\u5f02\u6b65\u8bf7\u6c42\u7ed3\u679c\uff1a" + result);
        }

        public void failed(Exception ex) {
            logger.error("\u5f02\u6b65\u8bf7\u6c42\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)ex);
        }

        public void cancelled() {
        }
    }
}

