/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.http;

import org.json.JSONObject;

public class HttpClientConfig {
    public static final Integer HTTP_MAX_POOL_SIZE = 256;
    public static final Integer HTTP_IDEL_TIME_OUT = 5000;
    private final Integer connectTimeout;
    private final Integer socketTimeout;

    private HttpClientConfig(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
    }

    private static HttpClientConfig create(Builder builder) {
        return new HttpClientConfig(builder);
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public static class Builder {
        private Integer connectTimeout = 10000;
        private Integer socketTimeout = 120000;

        public Builder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder socketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public HttpClientConfig build() {
            return HttpClientConfig.create(this);
        }

        public HttpClientConfig build(JSONObject config) {
            if (config.has("connectTimeOut")) {
                this.connectTimeout = config.getInt("connectTimeOut");
            }
            if (config.has("socketTimeout")) {
                this.socketTimeout = config.getInt("socketTimeout");
            }
            return HttpClientConfig.create(this);
        }
    }
}

