/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.http;

import com.af.v4.system.common.plugins.http.BaseHttpPoolUtil;
import com.af.v4.system.common.plugins.http.HttpClientConfig;
import com.af.v4.system.common.plugins.http.HttpConnectionPoolUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.json.JSONObject;

public class RestTools {
    public static String request(String value, String headers, HttpClientConfig config, ClassicHttpRequest base) {
        JSONObject headerJson = BaseHttpPoolUtil.buildHeader(headers);
        return HttpConnectionPoolUtil.request(value, headerJson.toString(), config, base);
    }

    public static String post(String path, String value, String headers) {
        return RestTools.request(value, headers, null, (ClassicHttpRequest)new HttpPost(path));
    }

    public static String post(String path, JSONObject value) {
        return RestTools.post(path, value == null ? null : value.toString(), null);
    }

    public static String postByFormData(String path, String value, String headers) {
        return HttpConnectionPoolUtil.requestFormUrlEncoded(value, headers, null, (ClassicHttpRequest)new HttpPost(path));
    }

    public static String postByFormData(String path, JSONObject value) {
        return RestTools.postByFormData(path, value == null ? null : value.toString(), null);
    }

    public static String get(String path, String headers) {
        return RestTools.request(null, headers, null, (ClassicHttpRequest)new HttpGet(path));
    }

    public static String get(String path) {
        return RestTools.get(path, null);
    }

    public static String put(String path, String value, String headers) {
        return RestTools.request(value, headers, null, (ClassicHttpRequest)new HttpPut(path));
    }

    public static String put(String path, JSONObject value) {
        return RestTools.put(path, value == null ? null : value.toString(), null);
    }

    public static String delete(String path, String value, String headers) {
        return RestTools.request(value, headers, null, (ClassicHttpRequest)new HttpDelete(path));
    }

    public static String delete(String path, JSONObject value) {
        return RestTools.delete(path, value.toString(), null);
    }

    public static String formatURL(String url, JSONObject params) {
        int capacity = params.length() * 30;
        StringBuilder buffer = new StringBuilder(capacity);
        buffer.append(url).append("?");
        Iterator keys = params.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = String.valueOf(params.get(key));
            if (!"".equals(val)) {
                buffer.append(key).append("=").append(val);
            } else {
                buffer.append(key);
            }
            if (!keys.hasNext()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    public static String formatAndEncodeURL(String url, JSONObject params) {
        String urlStr = RestTools.formatURL(url, params);
        return urlStr.substring(0, urlStr.indexOf("?") + 1) + URLEncoder.encode(urlStr.substring(urlStr.indexOf("?") + 1), StandardCharsets.UTF_8);
    }

    @Deprecated(since="1.1.8")
    public static String getStandardURL(String protocolType, String url, String port, String paramStr) {
        if (port == null) {
            port = "80";
        }
        url = protocolType + "://" + (String)url + ":" + port;
        if (paramStr != null) {
            url = (String)url + paramStr;
        }
        return url;
    }
}

