/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.http;

import com.af.v4.system.common.plugins.http.BaseHttpPoolUtil;
import com.af.v4.system.common.plugins.http.HttpClientConfig;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.message.BasicHeaderElementIterator;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionPoolUtil
extends BaseHttpPoolUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpConnectionPoolUtil.class);
    private static final Object SYNC_LOCK = new Object();
    private static volatile CloseableHttpClient httpClient;

    public static CloseableHttpClient getHttpClient(LayeredConnectionSocketFactory sslSocketFactory) {
        return HttpConnectionPoolUtil.createHttpClient(sslSocketFactory);
    }

    private static CloseableHttpClient createHttpClient() {
        return HttpConnectionPoolUtil.createHttpClient(null);
    }

    private static CloseableHttpClient createHttpClient(LayeredConnectionSocketFactory sslSocketFactory) {
        if (sslSocketFactory == null) {
            try {
                sslSocketFactory = new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(registry);
        manager.setMaxTotal(HttpClientConfig.HTTP_MAX_POOL_SIZE.intValue());
        manager.setDefaultMaxPerRoute(HttpClientConfig.HTTP_MAX_POOL_SIZE.intValue());
        ConnectionKeepAliveStrategy myStrategy = (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = (HeaderElement)it.next();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !"timeout".equalsIgnoreCase(param)) continue;
                try {
                    return TimeValue.ofSeconds((long)(Long.parseLong(value) * 1000L));
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return TimeValue.ofSeconds((long)5000L);
        };
        HttpClientConfig config = new HttpClientConfig.Builder().build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)config.getConnectTimeout().intValue())).setConnectTimeout(Timeout.ofSeconds((long)config.getConnectTimeout().intValue())).setResponseTimeout(Timeout.ofSeconds((long)config.getSocketTimeout().intValue())).build();
        return HttpClients.custom().setKeepAliveStrategy(myStrategy).setConnectionManagerShared(true).setConnectionManager((HttpClientConnectionManager)manager).setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(0, TimeValue.ofSeconds((long)1L))).evictExpiredConnections().evictIdleConnections(TimeValue.ofMilliseconds((long)HttpClientConfig.HTTP_IDEL_TIME_OUT.intValue())).setDefaultRequestConfig(requestConfig).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient getHttpClient() {
        if (httpClient == null) {
            Object object = SYNC_LOCK;
            synchronized (object) {
                if (httpClient == null) {
                    httpClient = HttpConnectionPoolUtil.createHttpClient();
                }
            }
        }
        return httpClient;
    }

    public static String request(String value, String headersStr, HttpClientConfig config, ClassicHttpRequest base) {
        return HttpConnectionPoolUtil.request(value, headersStr, config, base, null);
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, ClassicHttpRequest base) {
        return HttpConnectionPoolUtil.requestFormUrlEncoded(value, headersStr, config, base, null);
    }

    public static String request(String value, String headersStr, HttpClientConfig config, ClassicHttpRequest base, CloseableHttpClient httpClient) {
        String result;
        logger.info("\u8bf7\u6c42\u5730\u5740\uff1a" + base.getScheme() + "://" + base.getAuthority() + base.getPath());
        if (httpClient == null) {
            httpClient = HttpConnectionPoolUtil.getHttpClient();
        }
        HttpConnectionPoolUtil.setRequestConfig(config, (HttpRequest)base);
        HttpConnectionPoolUtil.setHeaders((HttpRequest)base, headersStr);
        if (base.getEntity() == null) {
            HttpConnectionPoolUtil.setBody((HttpRequest)base, value);
        }
        long begin = System.currentTimeMillis();
        try (CloseableHttpResponse response = httpClient.execute(base, (HttpContext)HttpClientContext.create());){
            result = HttpConnectionPoolUtil.getResponseData(begin, (HttpResponse)response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, ClassicHttpRequest base, CloseableHttpClient httpClient) {
        HttpConnectionPoolUtil.setUrlEncodedBody(base, value);
        return HttpConnectionPoolUtil.request(value, headersStr, config, base, httpClient);
    }
}

