/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.json;

import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.plugins.io.IOTools;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonTools {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static JSONObject addJSON(JSONObject obj, JSONObject addObj) {
        if (addObj == null) {
            throw new NullPointerException("\u8ffd\u52a0\u7684JSONObject\u4e0d\u5b58\u5728\uff01");
        }
        Set keys = addObj.keySet();
        for (String key : keys) {
            JSONObject cloneItem;
            Object item = addObj.get(key);
            if (item instanceof JSONObject) {
                JSONObject json = (JSONObject)item;
                cloneItem = new JSONObject(json.toMap());
                obj.put(key, (Object)cloneItem);
                continue;
            }
            if (item instanceof JSONArray) {
                JSONArray array = (JSONArray)item;
                cloneItem = new JSONArray((Collection)array.toList());
                obj.put(key, (Object)cloneItem);
                continue;
            }
            obj.put(key, item);
        }
        return obj;
    }

    public static JSONObject convertToJson(String str) {
        if (str == null || "".equals(str)) {
            return new JSONObject();
        }
        return new JSONObject(str);
    }

    public static JSONObject convertToJson(JSONObject json) {
        return json;
    }

    public static JSONArray parseArray(String str) {
        return new JSONArray(str);
    }

    public static JSONArray parseArray(JSONArray json) {
        return json;
    }

    public static JSONArray getArray() {
        return new JSONArray();
    }

    public static JSONArray getArray(Object val) {
        int len;
        try {
            len = new BigDecimal(val.toString()).intValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new JSONArray((Object)new String[len]);
    }

    public static JSONObject getJson() {
        return new JSONObject();
    }

    public static JSONObject replaceJSON(JSONObject oldObj, JSONObject newObj) {
        for (String key : newObj.keySet()) {
            oldObj.put(key, newObj.get(key));
        }
        return oldObj;
    }

    public static JSONObject readJsonFile(String fileName) {
        return new JSONObject(IOTools.readText(fileName));
    }

    public static JSONArray readJsonArrayFile(String fileName) {
        return new JSONArray(IOTools.readText(fileName));
    }

    public static JSONObject formatJsonByParams(JSONObject object, JSONObject params) {
        if (object.length() > 0) {
            return new JSONObject(CommonTools.formatStrByParams(object.toString(), params));
        }
        return object;
    }

    public static JSONArray formatJsonArrayByParams(JSONArray array, JSONObject params) {
        if (array.length() > 0) {
            return new JSONArray(CommonTools.formatStrByParams(array.toString(), params));
        }
        return array;
    }

    public static <T> T toParse(JSONObject json, Class<T> obj) {
        return JsonTools.toParse(json.toString(), obj);
    }

    public static <T> T toParse(String json, Class<T> obj) {
        Object t = null;
        try {
            t = objectMapper.readValue(json, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static <T> List<T> toParseList(JSONArray json, Class<T> obj) {
        List t = null;
        try {
            t = (List)objectMapper.readValue(json.toString(), JsonTools.getCollectionType(List.class, obj));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }

    public static JSONObject toJSON(Object entity) {
        try {
            return new JSONObject(objectMapper.writeValueAsString(entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> JSONArray toJsonArray(List<T> entity) {
        try {
            return new JSONArray(objectMapper.writeValueAsString(entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static <T> JSONObject objToJson(T obj) {
        try {
            return new JSONObject(objectMapper.writeValueAsString(obj));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return new JSONObject();
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

