package com.af.v4.system.common.plugins.calculate;

import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;

public interface ISettlementInterface {

    /**
     * 气量划价接口
     *
     * @param chargeInfo 用户价格方案明细
     * @param gas        累计购气量
     * @return 返回价格明细
     */
    JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas);

    /**
     * 气费划价接口
     *
     * @param chargeInfo 用户价格方案明细
     * @param fee        BigDecimal对象
     * @return 返回价格明细
     */
    JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee);
}
