/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.idea.gen;

import com.af.v4.system.common.plugins.idea.entity.Template;
import com.af.v4.system.common.plugins.idea.entity.TemplateGroup;
import com.af.v4.system.common.plugins.idea.entity.Variable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.json.JSONArray;
import org.json.JSONObject;

public class TemplatePlugin {
    public static final List<TemplateGroup> TEMPLATE_GROUP_LIST;

    public static void createXml() throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("templateSet").addAttribute("group", "Logic");
        TEMPLATE_GROUP_LIST.forEach(group -> {
            List<Template> templates = group.getTemplateList();
            templates.forEach(template -> {
                Element element = root.addElement("template");
                element.addAttribute("name", template.getName());
                element.addAttribute("value", template.getValue());
                element.addAttribute("description", template.getDescription());
                element.addAttribute("toReformat", "true");
                element.addAttribute("toShortenFQNames", "true");
                Variable[] variables = template.getVariableList();
                if (variables != null) {
                    for (Variable variable : variables) {
                        Element variableElement = element.addElement("variable");
                        variableElement.addAttribute("name", variable.getName());
                        variableElement.addAttribute("expression", variable.getExpression());
                        variableElement.addAttribute("defaultValue", "");
                        variableElement.addAttribute("alwaysStopAt", "true");
                    }
                }
                Element context = element.addElement("context");
                Element option = context.addElement("option");
                option.addAttribute("name", "OTHER");
                option.addAttribute("value", "true");
            });
        });
        OutputFormat of = OutputFormat.createPrettyPrint();
        of.setEncoding(StandardCharsets.UTF_8.name());
        File file = new File("Logic.xml");
        if (file.exists()) {
            file.delete();
        }
        XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(file), of);
        writer.write(document);
        writer.close();
    }

    public static void main(String[] args) throws IOException {
        TemplatePlugin.createXml();
    }

    static {
        ArrayList<Template> coreTemplates = new ArrayList<Template>();
        coreTemplates.add(new Template("log.debug(\u65e5\u5fd7\u5185\u5bb9)", "log.debug($str$)", "\u6253\u5370debug\u7ea7\u522b\u65e5\u5fd7\uff0c\u8fd4\u56de: void", new Variable("str", String.class)));
        coreTemplates.add(new Template("log.info(\u65e5\u5fd7\u5185\u5bb9)", "log.info($str$)", "\u6253\u5370info\u7ea7\u522b\u65e5\u5fd7\uff0c\u8fd4\u56de: void", new Variable("str", String.class)));
        coreTemplates.add(new Template("log.warn(\u65e5\u5fd7\u5185\u5bb9)", "log.warn($str$)", "\u6253\u5370warn\u7ea7\u522b\u65e5\u5fd7\uff0c\u8fd4\u56de: void", new Variable("str", String.class)));
        coreTemplates.add(new Template("log.error(\u65e5\u5fd7\u5185\u5bb9)", "log.error($str$)", "\u6253\u5370error\u7ea7\u522b\u65e5\u5fd7\uff0c\u8fd4\u56de: void", new Variable("str", String.class)));
        coreTemplates.add(new Template("logic.run(\u4e1a\u52a1\u903b\u8f91\u6620\u5c04\u540d, \u6267\u884c\u53c2\u6570)", "logic.run($name$, $params$)", "\u6267\u884c\u4e1a\u52a1\u903b\u8f91\uff0c\u8fd4\u56de: Object(\u6267\u884c\u7ed3\u679c)", new Variable("name", String.class), new Variable("params", JSONObject.class)));
        coreTemplates.add(new Template("logic.run(\u4e1a\u52a1\u903b\u8f91\u6620\u5c04\u540d, \u6267\u884c\u53c2\u6570, \u6570\u636e\u6e90\u540d\u79f0)", "logic.run($name$, $params$, $dataSource$)", "\u6267\u884c\u4e1a\u52a1\u903b\u8f91\uff0c\u8fd4\u56de: Object(\u6267\u884c\u7ed3\u679c)", new Variable("name", String.class), new Variable("params", JSONObject.class), new Variable("dataSource", String.class)));
        coreTemplates.add(new Template("logic.runAsync(\u4e1a\u52a1\u903b\u8f91\u6620\u5c04\u540d, \u6267\u884c\u53c2\u6570)", "logic.runAsync($name$, $params$)", "\u5f02\u6b65\u6267\u884c\u4e1a\u52a1\u903b\u8f91\uff0c\u8fd4\u56de: CompletableFuture<Object>", new Variable("name", String.class), new Variable("params", JSONObject.class)));
        coreTemplates.add(new Template("logic.remoteRun(\u670d\u52a1\u540d, \u4e1a\u52a1\u903b\u8f91\u6620\u5c04\u540d, \u6267\u884c\u53c2\u6570)", "logic.remoteRun($serviceName$, $name$, $params$)", "\u8fdc\u7a0b\u8c03\u7528\u4e1a\u52a1\u903b\u8f91\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("name", String.class), new Variable("params", JSONObject.class)));
        coreTemplates.add(new Template("sql.query(SQL\u6620\u5c04\u540d, \u6267\u884c\u53c2\u6570)", "sql.query($name$, $params$)", "\u6839\u636eSQL\u6587\u4ef6\u6267\u884c\u67e5\u8be2\uff0c\u8fd4\u56de: JSONArray(\u7ed3\u679c\u96c6)", new Variable("name", String.class), new Variable("param", JSONObject.class)));
        coreTemplates.add(new Template("sql.query(SQL\u6620\u5c04\u540d, \u6267\u884c\u53c2\u6570, \u6bcf\u9875\u6570\u91cf)", "sql.query($name$, $params$, $pageSize$)", "\u6839\u636eSQL\u6587\u4ef6\u6267\u884c\u67e5\u8be2\uff0c\u8fd4\u56de: JSONArray(\u7ed3\u679c\u96c6)", new Variable("name", String.class), new Variable("param", JSONObject.class), new Variable("pageSize", Integer.class)));
        coreTemplates.add(new Template("sql.query(SQL\u6620\u5c04\u540d, \u6267\u884c\u53c2\u6570, \u67e5\u8be2\u9875\u7801, \u6bcf\u9875\u6570\u91cf)", "sql.query($name$, $params$, $pageNo$, $pageSize$)", "\u6839\u636eSQL\u6587\u4ef6\u6267\u884c\u67e5\u8be2\uff0c\u8fd4\u56de: JSONArray(\u7ed3\u679c\u96c6)", new Variable("name", String.class), new Variable("param", JSONObject.class), new Variable("pageNo", Integer.class), new Variable("pageSize", Integer.class)));
        coreTemplates.add(new Template("sql.querySQL(SQL\u6807\u8bc6\u540d, SQL\u8bed\u53e5)", "sql.querySQL($name$, $sql$)", "\u6839\u636eSQL\u8bed\u53e5\u6267\u884c\u67e5\u8be2\uff0c\u8fd4\u56de: JSONArray(\u7ed3\u679c\u96c6)", new Variable("name", String.class), new Variable("sql", String.class)));
        coreTemplates.add(new Template("sql.querySQL(SQL\u6807\u8bc6\u540d, SQL\u8bed\u53e5, \u6bcf\u9875\u6570\u91cf)", "sql.querySQL($name$, $sql$, $pageSize$)", "\u6839\u636eSQL\u8bed\u53e5\u6267\u884c\u67e5\u8be2\uff0c\u8fd4\u56de: JSONArray(\u7ed3\u679c\u96c6)", new Variable("name", String.class), new Variable("sql", String.class), new Variable("pageSize", Integer.class)));
        coreTemplates.add(new Template("sql.querySQL(SQL\u6807\u8bc6\u540d, SQL\u8bed\u53e5, \u67e5\u8be2\u9875\u7801, \u6bcf\u9875\u6570\u91cf)", "sql.querySQL($name$, $sql$, $pageNo$, $pageSize$)", "\u6839\u636eSQL\u8bed\u53e5\u6267\u884c\u67e5\u8be2\uff0c\u8fd4\u56de: JSONArray(\u7ed3\u679c\u96c6)", new Variable("name", String.class), new Variable("sql", String.class), new Variable("pageNo", Integer.class), new Variable("pageSize", Integer.class)));
        coreTemplates.add(new Template("sql.exec(SQL\u6620\u5c04\u540d, \u6267\u884c\u53c2\u6570)", "sql.exec($name$, $params$)", "\u6839\u636eSQL\u6587\u4ef6\u6267\u884c\u589e\u5220\u6539\uff0c\u8fd4\u56de: Integer(\u5f71\u54cd\u884c\u6570)", new Variable("name", String.class), new Variable("param", JSONObject.class)));
        coreTemplates.add(new Template("sql.execSQL(SQL\u6807\u8bc6\u540d, SQL\u8bed\u53e5)", "sql.execSQL($name$, $sql$)", "\u6839\u636eSQL\u6587\u4ef6\u6267\u884c\u589e\u5220\u6539\uff0c\u8fd4\u56de: Integer(\u5f71\u54cd\u884c\u6570)", new Variable("name", String.class), new Variable("param", String.class)));
        coreTemplates.add(new Template("sql.getDbTypeName()", "sql.getDbTypeName()", "\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u8fd4\u56de: String(\u6570\u636e\u5e93\u7c7b\u578b)", new Variable[0]));
        coreTemplates.add(new Template("sql.resolveSQL(SQL\u96c6\u5408)", "sql.resolveSQL($sqlList$)", "\u89e3\u6790\u7b26\u5408\u6570\u636e\u6e90\u7684SQL\uff0c\u8fd4\u56de: String(SQL\u8bed\u53e5)", new Variable("sqlList", JSONObject.class)));
        coreTemplates.add(new Template("sql.openStandardTransformerSupport()", "sql.openStandardTransformerSupport()", "\u5f00\u542fSQL\u6267\u884c\u7ed3\u679c\u5217\u6709\u5e8f\uff08\u5f53\u524d\u7ebf\u7a0b\uff09\uff0c\u8fd4\u56de: void", new Variable[0]));
        coreTemplates.add(new Template("sql.closeStandardTransformerSupport()", "sql.closeStandardTransformerSupport()", "\u5173\u95edSQL\u6267\u884c\u7ed3\u679c\u5217\u6709\u5e8f\uff08\u5f53\u524d\u7ebf\u7a0b\uff09\uff0c\u8fd4\u56de: void", new Variable[0]));
        coreTemplates.add(new Template("sql.disableLogPrint()", "sql.disableLogPrint()", "\u7981\u7528SQL\u65e5\u5fd7\u6253\u5370\uff08\u5f53\u524d\u7ebf\u7a0b\uff09\uff0c\u8fd4\u56de: void", new Variable[0]));
        coreTemplates.add(new Template("sql.enableLogPrint()", "sql.enableLogPrint()", "\u542f\u7528SQL\u65e5\u5fd7\u6253\u5370\uff08\u5f53\u524d\u7ebf\u7a0b\uff09\uff0c\u8fd4\u56de: void", new Variable[0]));
        coreTemplates.add(new Template("entity.getCondition()", "entity.getCondition()", "\u751f\u6210\u67e5\u8be2\u8868\u8fbe\u5f0f\uff0c\u8fd4\u56de: Condition(af-common-jpa.utils.Condition)", new Variable[0]));
        coreTemplates.add(new Template("entity.getById(\u5217\u5b57\u6bb5, \u5b9e\u4f53\u540d, \u4e3b\u952e\u503c)", "entity.getById($column$, $entityName$, $id$)", "\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u6570\u636e\uff0c\u8fd4\u56de: JSONObject(\u5b9e\u4f53)", new Variable("column", String.class), new Variable("entityName", String.class), new Variable("id", Object.class)));
        coreTemplates.add(new Template("entity.getById(\u5b9e\u4f53\u540d, \u4e3b\u952e\u503c)", "entity.getById($entityName$, $id$)", "\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u6570\u636e\uff0c\u8fd4\u56de: JSONObject(\u5b9e\u4f53)", new Variable("entityName", String.class), new Variable("id", Object.class)));
        coreTemplates.add(new Template("entity.getByCondition(\u5217\u5b57\u6bb5, \u5b9e\u4f53\u540d, \u6761\u4ef6\u8868\u8fbe\u5f0f)", "entity.getByCondition($columns$, $entityName$, $condition$)", "\u6839\u636e\u6761\u4ef6\u8868\u8fbe\u5f0f\u67e5\u8be2\u6570\u636e\uff0c\u8fd4\u56de: JSONArray(\u7ed3\u679c\u96c6)", new Variable("columns", String.class), new Variable("entityName", String.class), new Variable("condition", Condition.class)));
        coreTemplates.add(new Template("entity.getByCondition(\u5b9e\u4f53\u540d, \u6761\u4ef6\u8868\u8fbe\u5f0f)", "entity.getByCondition($entityName$, $condition$)", "\u6839\u636e\u6761\u4ef6\u8868\u8fbe\u5f0f\u67e5\u8be2\u6570\u636e\uff0c\u8fd4\u56de: JSONArray(\u7ed3\u679c\u96c6)", new Variable("entityName", String.class), new Variable("condition", Condition.class)));
        coreTemplates.add(new Template("entity.delete(\u5b9e\u4f53\u540d, \u4e3b\u952e\u503c)", "entity.delete($entityName$, $id$)", "\u5220\u9664\u5355\u4e2a\u5b9e\u4f53\uff0c\u8fd4\u56de: Integer(\u5f71\u54cd\u884c\u6570)", new Variable("entityName", String.class), new Variable("id", Object.class)));
        coreTemplates.add(new Template("entity.deleteAllByIds(\u5b9e\u4f53\u540d, \u4e3b\u952e\u503c\u96c6\u5408)", "entity.deleteAllByIds($entityName$, $ids$)", "\u6279\u91cf\u5220\u9664\u5b9e\u4f53\uff0c\u8fd4\u56de: Integer(\u5f71\u54cd\u884c\u6570)", new Variable("entityName", String.class), new Variable("ids", JSONArray.class)));
        coreTemplates.add(new Template("entity.findAllByIds(\u5217\u5b57\u6bb5, \u5b9e\u4f53\u540d, \u4e3b\u952e\u503c\u96c6\u5408)", "entity.findAllByIds($columns$, $entityName$, $ids$)", "\u6839\u636e\u4e3b\u952e\u96c6\u5408\u67e5\u8be2\u6240\u6709\u6570\u636e\uff0c\u8fd4\u56de: JSONArray(\u7ed3\u679c\u96c6)", new Variable("columns", String.class), new Variable("entityName", String.class), new Variable("ids", JSONArray.class)));
        coreTemplates.add(new Template("entity.findAllByIds(\u5b9e\u4f53\u540d, \u4e3b\u952e\u503c\u96c6\u5408)", "entity.findAllByIds($entityName$, $ids$)", "\u6839\u636e\u4e3b\u952e\u96c6\u5408\u67e5\u8be2\u6240\u6709\u6570\u636e\uff0c\u8fd4\u56de: JSONArray(\u7ed3\u679c\u96c6)", new Variable("entityName", String.class), new Variable("ids", JSONArray.class)));
        coreTemplates.add(new Template("entity.getCount(\u5b9e\u4f53\u540d)", "entity.getCount($entityName$)", "\u67e5\u8be2\u5b9e\u4f53\u7684\u603b\u6570\u91cf\uff0c\u8fd4\u56de: Integer(\u603b\u6570)", new Variable("entityName", String.class)));
        coreTemplates.add(new Template("entity.findAll(\u5217\u5b57\u6bb5, \u5b9e\u4f53\u540d)", "entity.findAll($columns$, $entityName$)", "\u67e5\u8be2\u5b9e\u4f53\u7684\u6240\u6709\u6570\u636e\uff0c\u8fd4\u56de: JSONArray(\u7ed3\u679c\u96c6)", new Variable("columns", String.class), new Variable("entityName", String.class)));
        coreTemplates.add(new Template("entity.findAll(\u5b9e\u4f53\u540d)", "entity.findAll($entityName$)", "\u67e5\u8be2\u5b9e\u4f53\u7684\u6240\u6709\u6570\u636e\uff0c\u8fd4\u56de: JSONArray(\u7ed3\u679c\u96c6)", new Variable("entityName", String.class)));
        coreTemplates.add(new Template("entity.saveByKey(\u5b9e\u4f53\u540d, \u6570\u636e\u5b9e\u4f53, \u6307\u5b9a\u952e\u96c6\u5408, \u662f\u5426\u8986\u76d6\u5df2\u6709\u6570\u636e)", "entity.saveByKey($entityName$, $row$, $keyArray$, $isCover$)", "\u6839\u636e\u6307\u5b9a\u952e\u4fdd\u5b58\u5b9e\u4f53\uff0c\u8fd4\u56de\uff1aJSONObject(\u5b9e\u4f53)", new Variable("entityName", String.class), new Variable("row", JSONObject.class), new Variable("keyArray", JSONArray.class), new Variable("isCover", Boolean.class)));
        coreTemplates.add(new Template("entity.saveByKey(\u5b9e\u4f53\u540d, \u6570\u636e\u5b9e\u4f53, \u6307\u5b9a\u952e\u96c6\u5408)", "entity.saveByKey($entityName$, $row$, $keyArray$)", "\u6839\u636e\u6307\u5b9a\u952e\u4fdd\u5b58\u5b9e\u4f53(\u8986\u76d6\u5df2\u6709\u6570\u636e)\uff0c\u8fd4\u56de\uff1aJSONObject(\u5b9e\u4f53)", new Variable("entityName", String.class), new Variable("row", JSONObject.class), new Variable("keyArray", JSONArray.class)));
        coreTemplates.add(new Template("entity.partialSave(\u5b9e\u4f53\u540d, \u6570\u636e\u5b9e\u4f53)", "entity.partialSave($entityName$, $row$)", "\u5b9e\u4f53\u4fdd\u5b58\uff0c\u8fd4\u56de\uff1aJSONObject(\u5b9e\u4f53)", new Variable("entityName", String.class), new Variable("row", JSONObject.class)));
        coreTemplates.add(new Template("entity.partialSave(\u5b9e\u4f53\u540d, \u6570\u636e\u5b9e\u4f53\u96c6\u5408)", "entity.partialSave($entityName$, $rowArray$)", "\u5b9e\u4f53\u6279\u91cf\u4fdd\u5b58\uff0c\u8fd4\u56de\uff1aJSONArray(\u5b9e\u4f53\u96c6\u5408)", new Variable("entityName", String.class), new Variable("rowArray", JSONArray.class)));
        coreTemplates.add(new Template("entity.sqlserverBulkInsert(\u5b9e\u4f53\u540d, \u6570\u636e\u5b9e\u4f53\u96c6\u5408)", "entity.sqlserverBulkInsert($entityName$, $rowArray$)", "Sqlserver\u5927\u6570\u636e\u6279\u91cf\u63d2\u5165\uff0c\u8fd4\u56de\uff1avoid", new Variable("entityName", String.class), new Variable("rowArray", JSONArray.class)));
        coreTemplates.add(new Template("entity.remoteDelete(\u670d\u52a1\u540d, \u5b9e\u4f53\u540d, \u4e3b\u952e\u503c)", "entity.remoteDelete($serviceName$, $entityName$, $id$)", "\u8fdc\u7a0b\u8c03\u7528\u5220\u9664\u5b9e\u4f53\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("entityName", String.class), new Variable("id", Object.class)));
        coreTemplates.add(new Template("entity.remoteDeleteAllByIds(\u670d\u52a1\u540d, \u5b9e\u4f53\u540d, \u4e3b\u952e\u503c\u96c6\u5408)", "entity.remoteDeleteAllByIds($serviceName$, $entityName$, $ids$)", "\u8fdc\u7a0b\u8c03\u7528\u6279\u91cf\u5220\u9664\u5b9e\u4f53\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("entityName", String.class), new Variable("ids", JSONArray.class)));
        coreTemplates.add(new Template("entity.remoteFindAllByIds(\u670d\u52a1\u540d, \u5217\u5b57\u6bb5, \u5b9e\u4f53\u540d, \u4e3b\u952e\u503c\u96c6\u5408)", "entity.remoteFindAllByIds($serviceName$, $columns$, $entityName$, $ids$)", "\u8fdc\u7a0b\u8c03\u7528\u6839\u636e\u4e3b\u952e\u96c6\u5408\u67e5\u8be2\u6240\u6709\u6570\u636e\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("columns", String.class), new Variable("entityName", String.class), new Variable("ids", JSONArray.class)));
        coreTemplates.add(new Template("entity.remoteFindAllByIds(\u670d\u52a1\u540d, \u5b9e\u4f53\u540d, \u4e3b\u952e\u503c\u96c6\u5408)", "entity.remoteFindAllByIds($serviceName$, $columns$, $entityName$, $ids$)", "\u8fdc\u7a0b\u8c03\u7528\u6839\u636e\u4e3b\u952e\u96c6\u5408\u67e5\u8be2\u6240\u6709\u6570\u636e\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("entityName", String.class), new Variable("ids", JSONArray.class)));
        coreTemplates.add(new Template("entity.remoteGetCount(\u670d\u52a1\u540d, \u5b9e\u4f53\u540d)", "entity.remoteGetCount($serviceName$, $entityName$)", "\u8fdc\u7a0b\u8c03\u7528\u67e5\u8be2\u5b9e\u4f53\u7684\u603b\u6570\u91cf\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("entityName", String.class)));
        coreTemplates.add(new Template("entity.remoteFindAll(\u670d\u52a1\u540d, \u5217\u5b57\u6bb5, \u5b9e\u4f53\u540d)", "entity.remoteFindAll($serviceName$, $columns$, $entityName$)", "\u8fdc\u7a0b\u8c03\u7528\u67e5\u8be2\u6240\u6709\u6570\u636e\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("columns", String.class), new Variable("entityName", String.class)));
        coreTemplates.add(new Template("entity.remoteFindAll(\u670d\u52a1\u540d, \u5b9e\u4f53\u540d)", "entity.remoteFindAll($serviceName$, $entityName$)", "\u8fdc\u7a0b\u8c03\u7528\u67e5\u8be2\u6240\u6709\u6570\u636e\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("entityName", String.class)));
        coreTemplates.add(new Template("entity.remoteGetById(\u670d\u52a1\u540d, \u5217\u5b57\u6bb5, \u5b9e\u4f53\u540d, \u4e3b\u952e\u503c)", "entity.remoteGetById($serviceName$, $columns$, $entityName$, $id$)", "\u8fdc\u7a0b\u8c03\u7528\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u6570\u636e\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("columns", String.class), new Variable("entityName", String.class), new Variable("id", Object.class)));
        coreTemplates.add(new Template("entity.remoteGetById(\u670d\u52a1\u540d, \u5b9e\u4f53\u540d, \u4e3b\u952e\u503c)", "entity.remoteGetById($serviceName$, $entityName$, $id$)", "\u8fdc\u7a0b\u8c03\u7528\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u6570\u636e\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("entityName", String.class), new Variable("id", Object.class)));
        coreTemplates.add(new Template("entity.remoteSaveByKey(\u670d\u52a1\u540d, \u5b9e\u4f53\u540d, \u6570\u636e\u5b9e\u4f53, \u6307\u5b9a\u952e\u96c6\u5408, \u662f\u5426\u8986\u76d6\u5df2\u6709\u6570\u636e)", "entity.remoteSaveByKey($serviceName$, $entityName$, $row$, $keyArray$, $isCover$)", "\u8fdc\u7a0b\u6839\u636e\u6307\u5b9a\u952e\u4fdd\u5b58\u5b9e\u4f53\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("entityName", String.class), new Variable("row", JSONObject.class), new Variable("keyArray", JSONArray.class), new Variable("isCover", Boolean.class)));
        coreTemplates.add(new Template("entity.remoteSaveByKey(\u670d\u52a1\u540d, \u5b9e\u4f53\u540d, \u6570\u636e\u5b9e\u4f53, \u6307\u5b9a\u952e\u96c6\u5408)", "entity.remoteGetById($serviceName$, $entityName$, $row$, $keyArray$)", "\u8fdc\u7a0b\u6839\u636e\u6307\u5b9a\u952e\u4fdd\u5b58\u5b9e\u4f53\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("entityName", String.class), new Variable("row", JSONObject.class), new Variable("keyArray", JSONArray.class)));
        coreTemplates.add(new Template("entity.remotePartialSave(\u670d\u52a1\u540d, \u5b9e\u4f53\u540d, \u6570\u636e\u5b9e\u4f53)", "entity.remotePartialSave($serviceName$, $entityName$, $row$)", "\u8fdc\u7a0b\u8c03\u7528\u5b9e\u4f53\u4fdd\u5b58\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("entityName", String.class), new Variable("row", JSONObject.class)));
        coreTemplates.add(new Template("entity.remotePartialSave(\u670d\u52a1\u540d, \u5b9e\u4f53\u540d, \u6570\u636e\u5b9e\u4f53\u96c6\u5408)", "entity.remotePartialSave($serviceName$, $entityName$, $rowArray$)", "\u8fdc\u7a0b\u8c03\u7528\u5b9e\u4f53\u6279\u91cf\u4fdd\u5b58\uff0c\u8fd4\u56de: JSONObject(\u6267\u884c\u7ed3\u679c)", new Variable("serviceName", String.class), new Variable("entityName", String.class), new Variable("rowArray", JSONArray.class)));
        coreTemplates.add(new Template("redis.set(\u952e, \u503c)", "redis.set($key$, $value$)", "redis\u4fdd\u5b58\u6570\u636e\uff0c\u8fd4\u56de: Object(\u5b58\u5165\u7684\u6570\u636e\u5bf9\u8c61)", new Variable("key", String.class), new Variable("value", Object.class)));
        coreTemplates.add(new Template("redis.set(\u952e, \u503c, \u8fc7\u671f\u65f6\u95f4(\u79d2))", "redis.set($key$, $value$, $timeoutSec$)", "redis\u4fdd\u5b58\u6570\u636e\uff0c\u8fd4\u56de: Object(\u5b58\u5165\u7684\u6570\u636e\u5bf9\u8c61)", new Variable("key", String.class), new Variable("value", Object.class), new Variable("timeoutSec", Object.class)));
        coreTemplates.add(new Template("redis.get(\u952e)", "redis.get($key$)", "redis\u6839\u636ekey\u83b7\u53d6\u6570\u636e\uff0c\u8fd4\u56de: Object(\u5b58\u5165\u7684\u6570\u636e\u5bf9\u8c61)", new Variable("key", String.class)));
        coreTemplates.add(new Template("redis.hasKey(\u952e)", "redis.hasKey($key$)", "redis\u5224\u65adkey\u662f\u5426\u5b58\u5728\uff0c\u8fd4\u56de: Boolean", new Variable("key", String.class)));
        coreTemplates.add(new Template("redis.delete(\u952e)", "redis.delete($key$)", "redis\u6839\u636ekey\u5220\u9664\u6570\u636e\uff0c\u8fd4\u56de: void", new Variable("key", String.class)));
        coreTemplates.add(new Template("redis.deleteList(\u952e\u96c6\u5408)", "redis.deleteList($keys$)", "redis\u6839\u636ekey\u96c6\u5408\u5220\u9664\u6570\u636e\uff0c\u8fd4\u56de: void", new Variable("keys", JSONArray.class)));
        coreTemplates.add(new Template("liuLiConfig.get(\u914d\u7f6e\u540d\u79f0)", "liuLiConfig.get($configName$)", "\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\uff0c\u8fd4\u56de: JSONObject", new Variable("configName", String.class)));
        TemplateGroup core = new TemplateGroup("\u6838\u5fc3", "core", coreTemplates);
        ArrayList<Template> pluginsTemplates = new ArrayList<Template>();
        pluginsTemplates.add(new Template("commonTools.getInstance(\u5168\u9650\u5b9a\u7c7b\u540d, \u6784\u9020\u53c2\u6570\u96c6\u5408)", "commonTools.getInstance($className$, $constructorParam$)", "\u53cd\u5c04\u83b7\u53d6\u5bf9\u8c61\u5b9e\u4f8b\uff0c\u8fd4\u56de: Object(\u5bf9\u8c61\u5b9e\u4f8b)", new Variable("className", String.class), new Variable("constructorParam", JSONArray.class)));
        pluginsTemplates.add(new Template("commonTools.getInstance(\u5168\u9650\u5b9a\u7c7b\u540d)", "commonTools.getInstance($className$)", "\u53cd\u5c04\u83b7\u53d6\u5bf9\u8c61\u5b9e\u4f8b\uff0c\u8fd4\u56de: Object(\u5bf9\u8c61\u5b9e\u4f8b)", new Variable("className", String.class)));
        pluginsTemplates.add(new Template("commonTools.getUUID(\u662f\u5426\u5e26\u5206\u9694\u5b57\u7b26)", "commonTools.getUUID($isSimple$)", "\u751f\u6210\u4e00\u4e2aUUID\uff0c\u8fd4\u56de: String(UUID\u5b57\u7b26\u4e32)", new Variable("isSimple", Boolean.class)));
        pluginsTemplates.add(new Template("commonTools.getUUID()", "commonTools.getUUID()", "\u751f\u6210\u4e00\u4e2a\u5e26\u5206\u9694\u5b57\u7b26\u7684UUID\uff0c\u8fd4\u56de: String(UUID\u5b57\u7b26\u4e32)", new Variable[0]));
        pluginsTemplates.add(new Template("commonTools.md5(\u5185\u5bb9)", "commonTools.md5($value$)", "md5\u7f16\u7801\uff0c\u8fd4\u56de: String(MD5\u5b57\u7b26\u4e32)", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.md5(\u5185\u5bb9, \u76d0\u503c)", "commonTools.md5($value$, $salt$)", "md5\u7f16\u7801\uff0c\u8fd4\u56de: String(MD5\u5b57\u7b26\u4e32)", new Variable("value", String.class), new Variable("salt", String.class)));
        pluginsTemplates.add(new Template("commonTools.getRandomNumber(\u6700\u5c0f\u503c(\u5305\u542b), \u6700\u5927\u503c(\u5305\u542b))", "commonTools.getRandomNumber($min$, $max$)", "\u83b7\u53d6\u6307\u5b9a\u8303\u56f4\u7684\u4f2a\u968f\u673a\u6570\uff0c\u8fd4\u56de: Integer(\u968f\u673a\u6570)", new Variable("min", Integer.class), new Variable("max", Integer.class)));
        pluginsTemplates.add(new Template("commonTools.isNumeric(\u5185\u5bb9)", "commonTools.isNumeric($value$)", "\u5224\u65ad\u5185\u5bb9\u662f\u5426\u4e3a\u6570\u5b57\uff0c\u8fd4\u56de: Boolean", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.add(\u88ab\u52a0\u6570, \u52a0\u6570)", "commonTools.add($num1$, $num2$)", "\u7cbe\u786e\u52a0\u6cd5\u8fd0\u7b97\uff0c\u8fd4\u56de: BigDecimal", new Variable("num1", Object.class), new Variable("num2", Object.class)));
        pluginsTemplates.add(new Template("commonTools.add(\u88ab\u52a0\u6570, \u52a0\u6570, \u7cbe\u5ea6)", "commonTools.add($num1$, $num2$, $scale$)", "\u7cbe\u786e\u52a0\u6cd5\u8fd0\u7b97\uff0c\u8fd4\u56de: BigDecimal", new Variable("num1", Object.class), new Variable("num2", Object.class), new Variable("scale", Integer.class)));
        pluginsTemplates.add(new Template("commonTools.sub(\u88ab\u51cf\u6570, \u51cf\u6570)", "commonTools.sub($num1$, $num2$)", "\u7cbe\u786e\u51cf\u6cd5\u8fd0\u7b97\uff0c\u8fd4\u56de: BigDecimal", new Variable("num1", Object.class), new Variable("num2", Object.class)));
        pluginsTemplates.add(new Template("commonTools.sub(\u88ab\u52a0\u6570, \u52a0\u6570, \u7cbe\u5ea6)", "commonTools.sub($num1$, $num2$, $scale$)", "\u7cbe\u786e\u51cf\u6cd5\u8fd0\u7b97\uff0c\u8fd4\u56de: BigDecimal", new Variable("num1", Object.class), new Variable("num2", Object.class), new Variable("scale", Integer.class)));
        pluginsTemplates.add(new Template("commonTools.mul(\u88ab\u4e58\u6570, \u4e58\u6570)", "commonTools.mul($num1$, $num2$)", "\u7cbe\u786e\u4e58\u6cd5\u8fd0\u7b97\uff0c\u8fd4\u56de: BigDecimal", new Variable("num1", Object.class), new Variable("num2", Object.class)));
        pluginsTemplates.add(new Template("commonTools.mul(\u88ab\u4e58\u6570, \u4e58\u6570, \u7cbe\u5ea6)", "commonTools.mul($num1$, $num2$, $scale$)", "\u7cbe\u786e\u4e58\u6cd5\u8fd0\u7b97\uff0c\u8fd4\u56de: BigDecimal", new Variable("num1", Object.class), new Variable("num2", Object.class), new Variable("scale", Integer.class)));
        pluginsTemplates.add(new Template("commonTools.div(\u88ab\u9664\u6570, \u9664\u6570)", "commonTools.div($num1$, $num2$)", "\u7cbe\u786e\u9664\u6cd5\u8fd0\u7b97\uff0c\u8fd4\u56de: BigDecimal", new Variable("num1", Object.class), new Variable("num2", Object.class)));
        pluginsTemplates.add(new Template("commonTools.div(\u88ab\u9664\u6570, \u9664\u6570, \u7cbe\u5ea6)", "commonTools.div($num1$, $num2$, $scale$)", "\u7cbe\u786e\u9664\u6cd5\u8fd0\u7b97\uff0c\u8fd4\u56de: BigDecimal", new Variable("num1", Object.class), new Variable("num2", Object.class), new Variable("scale", Integer.class)));
        pluginsTemplates.add(new Template("commonTools.split(\u5185\u5bb9, \u5206\u5272\u7b26)", "commonTools.split($content$, $separator$)", "\u5b57\u7b26\u4e32\u5206\u5272\uff0c\u8fd4\u56de: JSONArray", new Variable("content", String.class), new Variable("separator", String.class)));
        pluginsTemplates.add(new Template("commonTools.url2json(URL\u53c2\u6570)", "commonTools.url2json($urlParams$)", "Url\u53c2\u6570\u8f6cJson\uff0c\u8fd4\u56de: JSONObject", new Variable("urlParams", String.class)));
        pluginsTemplates.add(new Template("commonTools.isContains(\u5b57\u7b26\u4e32, \u641c\u7d22\u503c)", "commonTools.isContains($str$, $searchStr$)", "\u6307\u5b9a\u5b57\u7b26\u4e32\u662f\u5426\u5728\u5b57\u7b26\u4e32\u4e2d\u51fa\u73b0\u8fc7\uff0c\u8fd4\u56de: Boolean", new Variable("str", String.class), new Variable("searchStr", String.class)));
        pluginsTemplates.add(new Template("commonTools.union(JSON\u96c6\u5408)", "commonTools.union($array$)", "\u5408\u5e76JSONArray\u91cc\u7684\u6240\u6709\u5b57\u7b26\u4e32\uff0c\u5f62\u5f0f\u4e3a\uff1a'a','b'\uff0c\u8fd4\u56de: String", new Variable("array", JSONArray.class)));
        pluginsTemplates.add(new Template("commonTools.union(JSON\u96c6\u5408, key)", "commonTools.union($array$, $key$)", "\u5408\u5e76JSONArray\u91ccJSONObject\u6307\u5b9akey\u7684\u6240\u6709\u5b57\u7b26\u4e32\uff0c\u5f62\u5f0f\u4e3a\uff1a'a','b'\uff0c\u8fd4\u56de: String", new Variable("array", JSONArray.class), new Variable("key", String.class)));
        pluginsTemplates.add(new Template("commonTools.formatStrByParams(\u5b57\u7b26\u4e32\u5185\u5bb9, \u53c2\u6570JSON)", "commonTools.formatStrByParams($content$, $params$)", "\u6839\u636e\u53c2\u6570\u5b57\u5178\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\uff0c\u8fd4\u56de: String", new Variable("content", String.class), new Variable("params", JSONObject.class)));
        pluginsTemplates.add(new Template("commonTools.formatNumber(\u6570\u5b57\u503c)", "commonTools.formatNumber($number$)", "\u5c06\u6570\u5b57\u6309\u6807\u51c6\u683c\u5f0f\u8f6c\u6362\uff0c\u8fd4\u56de: String", new Variable("number", Object.class)));
        pluginsTemplates.add(new Template("commonTools.stringToInt(\u5b57\u7b26\u4e32)", "commonTools.stringToInt($value$)", "\u5b57\u7b26\u4e32\u8f6c\u6574\u6570\uff0c\u8fd4\u56de: Integer", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.stringToDouble(\u5b57\u7b26\u4e32)", "commonTools.stringToDouble($value$)", "\u5b57\u7b26\u4e32\u8f6cDouble\uff0c\u8fd4\u56de: Double", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.stringToBigDecimal(\u5b57\u7b26\u4e32)", "commonTools.stringToBigDecimal($value$)", "\u5b57\u7b26\u4e32\u8f6cBigDecimal\uff0c\u8fd4\u56de: BigDecimal", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.bigDecimalToString(BigDecimal\u5bf9\u8c61)", "commonTools.bigDecimalToString($value$)", "BigDecimal\u8f6cString\uff0c\u8fd4\u56de: String", new Variable("value", BigDecimal.class)));
        pluginsTemplates.add(new Template("commonTools.byteArrayToString(\u5b57\u8282\u6570\u7ec4)", "commonTools.byteArrayToString($value$)", "byte\u6570\u7ec4\u8f6c\u5b57\u7b26\u4e32\uff0c\u8fd4\u56de: String", new Variable("value", byte[].class)));
        pluginsTemplates.add(new Template("commonTools.byteArrayToCharsetString(\u5b57\u8282\u6570\u7ec4, \u7f16\u7801\u683c\u5f0f)", "commonTools.byteArrayToCharsetString($value$, $charset$)", "byte\u6570\u7ec4\u8f6c\u5b57\u7b26\u4e32\uff0c\u8fd4\u56de: String", new Variable("value", byte[].class), new Variable("charset", String.class)));
        pluginsTemplates.add(new Template("commonTools.base64Encode(\u5b57\u8282\u6570\u7ec4)", "commonTools.base64Encode($value$)", "\u5bf9byte\u6570\u7ec4Base64\u7f16\u7801\uff0c\u8fd4\u56de: String", new Variable("value", byte[].class)));
        pluginsTemplates.add(new Template("commonTools.base64Decode(\u5b57\u8282\u6570\u7ec4)", "commonTools.base64Decode($value$)", "\u5bf9byte\u6570\u7ec4Base64\u89e3\u7801\uff0c\u8fd4\u56de: String", new Variable("value", byte[].class)));
        pluginsTemplates.add(new Template("commonTools.byteToHexStr(\u5b57\u8282\u6570\u7ec4)", "commonTools.byteToHexStr($value$)", "byte\u6570\u7ec4\u8f6c16\u8fdb\u5236\u5b57\u7b26\u4e32\uff0c\u8fd4\u56de: String", new Variable("value", byte[].class)));
        pluginsTemplates.add(new Template("commonTools.hexStrToByte(16\u8fdb\u5236\u5b57\u7b26\u4e32)", "commonTools.hexStrToByte($value$)", "16\u8fdb\u5236\u5b57\u7b26\u4e32\u8f6cbyte\u6570\u7ec4\uff0c\u8fd4\u56de: byte[]", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.strToBytes(\u5b57\u7b26\u4e32)", "commonTools.strToBytes($value$)", "\u5b57\u7b26\u4e32\u8f6cbyte\u6570\u7ec4\uff0c\u8fd4\u56de: byte[]", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.bytesToStr(\u5b57\u8282\u6570\u7ec4)", "commonTools.bytesToStr($value$)", "byte\u6570\u7ec4\u8f6c\u5b57\u7b26\u4e32\uff0c\u8fd4\u56de: String", new Variable("value", byte[].class)));
        pluginsTemplates.add(new Template("commonTools.stringToCharset(\u5b57\u7b26\u4e32, \u539f\u7f16\u7801\u683c\u5f0f, \u65b0\u7f16\u7801\u683c\u5f0f)", "commonTools.stringToCharset($value$, $oldCharset$, $newCharset$)", "\u6839\u636e\u6307\u5b9a\u7f16\u7801\u683c\u5f0f\u8f6c\u6362\u5b57\u7b26\u4e32\uff0c\u8fd4\u56de: String", new Variable("value", byte[].class), new Variable("oldCharset", String.class), new Variable("newCharset", String.class)));
        pluginsTemplates.add(new Template("commonTools.ceil(\u6570\u5b57\u503c)", "commonTools.ceil($value$)", "\u5411\u4e0a\u53d6\u6574\uff0c\u8fd4\u56de: Integer", new Variable("value", Object.class)));
        pluginsTemplates.add(new Template("commonTools.ceil(\u6570\u5b57\u503c, \u7cbe\u5ea6)", "commonTools.ceil($value$, $scale$)", "\u6309\u7cbe\u5ea6\u5411\u4e0a\u8f6c\u6362\uff0c\u8fd4\u56de: Double", new Variable("value", Object.class), new Variable("scale", Object.class)));
        pluginsTemplates.add(new Template("commonTools.floor(\u6570\u5b57\u503c)", "commonTools.floor($value$)", "\u5411\u4e0b\u53d6\u6574\uff0c\u8fd4\u56de: Integer", new Variable("value", Object.class)));
        pluginsTemplates.add(new Template("commonTools.floor(\u6570\u5b57\u503c, \u7cbe\u5ea6)", "commonTools.floor($value$, $scale$)", "\u6309\u7cbe\u5ea6\u5411\u4e0b\u8f6c\u6362\uff0c\u8fd4\u56de: Double", new Variable("value", Object.class), new Variable("scale", Object.class)));
        pluginsTemplates.add(new Template("commonTools.round(\u6570\u5b57\u503c)", "commonTools.round($value$)", "\u56db\u820d\u4e94\u5165\u53d6\u6574\uff0c\u8fd4\u56de: Integer", new Variable("value", Object.class)));
        pluginsTemplates.add(new Template("commonTools.round(\u6570\u5b57\u503c, \u7cbe\u5ea6)", "commonTools.round($value$, $scale$)", "\u6309\u7cbe\u5ea6\u56db\u820d\u4e94\u5165\uff0c\u8fd4\u56de: Double", new Variable("value", Object.class), new Variable("scale", Object.class)));
        pluginsTemplates.add(new Template("commonTools.replaceAll(\u5f85\u66ff\u6362\u5b57\u7b26\u4e32)", "commonTools.replaceAll($value$)", "\u53bb\u9664\u5b57\u7b26\u4e32\u6240\u6709\u7a7a\u683c\uff0c\u8fd4\u56de: String", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("commonTools.splitString(\u5f85\u5206\u5272\u5185\u5bb9, \u5206\u5272\u7b26)", "commonTools.splitString($value$, $flag$)", "\u5b57\u7b26\u4e32\u5206\u5272\u6210JSON\u96c6\u5408\uff0c\u8fd4\u56de: JSONArray", new Variable("value", String.class), new Variable("flag", String.class)));
        pluginsTemplates.add(new Template("dateTools.getNow2()", "dateTools.getNow2()", "\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u5b57\u7b26\u4e32(\u683c\u5f0f:yyyy-MM-dd HH:mm:ss)\uff0c\u8fd4\u56de: String", new Variable[0]));
        pluginsTemplates.add(new Template("dateTools.getCurrentTimeMillis()", "dateTools.getCurrentTimeMillis()", "\u83b7\u53d6\u5f53\u524d\u65f6\u95f4\u6233\uff0c\u8fd4\u56de: Long", new Variable[0]));
        pluginsTemplates.add(new Template("dateTools.getNow(\u76ee\u6807\u65e5\u671f\u683c\u5f0f)", "dateTools.getNow($format$)", "\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u5b57\u7b26\u4e32\uff0c\u8fd4\u56de: String", new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.getNowYear()", "dateTools.getNowYear()", "\u8fd4\u56de\u5f53\u524d\u65e5\u671f\u7684\u5e74\u4efd\uff0c\u8fd4\u56de: String", new Variable[0]));
        pluginsTemplates.add(new Template("dateTools.getNowMonth()", "dateTools.getNowMonth()", "\u8fd4\u56de\u5f53\u524d\u65e5\u671f\u7684\u6708\u4efd\uff0c\u8fd4\u56de: String", new Variable[0]));
        pluginsTemplates.add(new Template("dateTools.getNowMonthAsInt()", "dateTools.getNowMonthAsInt()", "\u8fd4\u56de\u5f53\u524d\u65e5\u671f\u7684\u6708\u4efd\u6574\u6570\uff0c\u8fd4\u56de: Integer", new Variable[0]));
        pluginsTemplates.add(new Template("dateTools.getNowDay()", "dateTools.getNowDay()", "\u8fd4\u56de\u5f53\u524d\u65e5\u671f\u7684\u5929\uff0c\u8fd4\u56de: String", new Variable[0]));
        pluginsTemplates.add(new Template("dateTools.getNowDayOfWeek()", "dateTools.getNowDayOfWeek()", "\u8fd4\u56de\u5f53\u524d\u65e5\u671f\u7684\u661f\u671f\uff0c\u8fd4\u56de: String", new Variable[0]));
        pluginsTemplates.add(new Template("dateTools.getMonth(\u65e5\u671f\u4e32)", "dateTools.getMonth($value$)", "\u83b7\u53d6\u6307\u5b9a\u65e5\u671f\u7684\u6708\u4efd\uff0c\u8fd4\u56de: Integer", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("dateTools.getDate(\u65e5\u671f\u4e32)", "dateTools.getDate($value$)", "\u83b7\u53d6\u6307\u5b9a\u65e5\u671f\u7684\u5929\uff0c\u8fd4\u56de: Integer", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("dateTools.getYearMonth(\u65e5\u671f\u4e32)", "dateTools.getYearMonth($value$)", "\u83b7\u53d6\u6307\u5b9a\u65e5\u671f\u7684\u5e74\u6708(\u683c\u5f0f:yyyyMM)\uff0c\u8fd4\u56de: String", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("dateTools.format(\u65e5\u671f\u4e32, \u76ee\u6807\u65e5\u671f\u683c\u5f0f)", "dateTools.format($value$, $format$)", "\u683c\u5f0f\u5316\u65e5\u671f\u5b57\u7b26\u4e32\uff0c\u8fd4\u56de: String", new Variable("value", String.class), new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.formatDateTime(\u65e5\u671f\u5b57\u7b26\u4e32)", "dateTools.formatDateTime($value$)", "\u5c06\u65e5\u671f\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u6807\u51c6\u65e5\u671f\u683c\u5f0f\uff0c\u8fd4\u56de: String", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("dateTools.formatDateTime(\u65e5\u671f\u4e32, \u8be5\u5b57\u7b26\u4e32\u7684\u65e5\u671f\u683c\u5f0f)", "dateTools.formatDateTime($value$, $format$)", "\u5c06\u6307\u5b9a\u65e5\u671f\u683c\u5f0f\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u6807\u51c6\u65e5\u671f\u683c\u5f0f\uff0c\u8fd4\u56de: String", new Variable("value", String.class), new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.formatDateTime(\u65e5\u671f\u4e32, \u539f\u65e5\u671f\u683c\u5f0f, \u76ee\u6807\u65e5\u671f\u683c\u5f0f)", "dateTools.formatDateTime($value$, $format$, $newFormat$)", "\u683c\u5f0f\u5316\u65e5\u671f\u5b57\u7b26\u4e32\uff0c\u8fd4\u56de: String", new Variable("value", String.class), new Variable("format", String.class), new Variable("newFormat", String.class)));
        pluginsTemplates.add(new Template("dateTools.compareDate(\u65e5\u671f\u4e321, \u65e5\u671f\u4e322)", "dateTools.compareDate($value$, $value2$)", "\u6bd4\u8f83\u4e24\u4e2a\u65e5\u671f\u7684\u5927\u5c0f\uff0c\u8fd4\u56de: Boolean(a>=b)", new Variable("value", String.class), new Variable("value2", String.class)));
        pluginsTemplates.add(new Template("dateTools.compareFormatDate(\u65e5\u671f\u4e321, \u65e5\u671f\u4e322, \u65e5\u671f\u683c\u5f0f)", "dateTools.compareFormatDate($value$, $value2$, $format$)", "\u6bd4\u8f83\u4e24\u4e2a\u65e5\u671f\u7684\u5927\u5c0f\uff0c\u8fd4\u56de: Boolean(a>=b)", new Variable("value", String.class), new Variable("value2", String.class), new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.getStartDate(\u65e5\u671f\u4e32, \u64cd\u4f5c\u7c7b\u578b, \u76ee\u6807\u65e5\u671f\u683c\u5f0f)", "dateTools.getStartDate($value$, $type$, $format$)", "\u83b7\u53d6\u6307\u5b9a\u65e5\u671f\u7684\u5f00\u59cb\u65e5\u671f\uff0c\u8fd4\u56de: String", new Variable("value", String.class), new Variable("type", String.class), new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.getStartDate(\u65e5\u671f\u4e32, \u64cd\u4f5c\u7c7b\u578b)", "dateTools.getStartDate($value$, $type$)", "\u83b7\u53d6\u6307\u5b9a\u65e5\u671f\u7684\u5f00\u59cb\u65e5\u671f\uff0c\u8fd4\u56de: String", new Variable("value", String.class), new Variable("type", String.class)));
        pluginsTemplates.add(new Template("dateTools.getEndDate(\u65e5\u671f\u4e32, \u64cd\u4f5c\u7c7b\u578b, \u76ee\u6807\u65e5\u671f\u683c\u5f0f)", "dateTools.getEndDate($value$, $type$, $format$)", "\u83b7\u53d6\u6307\u5b9a\u65e5\u671f\u7684\u7ed3\u675f\u65e5\u671f\uff0c\u8fd4\u56de: String", new Variable("value", String.class), new Variable("type", String.class), new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.getEndDate(\u65e5\u671f\u4e32, \u64cd\u4f5c\u7c7b\u578b)", "dateTools.getEndDate($value$, $type$)", "\u83b7\u53d6\u6307\u5b9a\u65e5\u671f\u7684\u7ed3\u675f\u65e5\u671f\uff0c\u8fd4\u56de: String", new Variable("value", String.class), new Variable("type", String.class)));
        pluginsTemplates.add(new Template("dateTools.getStairStartDate(\u5f00\u59cb\u65e5\u671f\u4e32, \u9636\u68af\u5468\u671f, \u6284\u8868\u65e5\u671f\u4e32)", "dateTools.getStairStartDate($start$, $cycle$, $handDate$)", "\u83b7\u53d6\u9636\u68af\u5f00\u59cb\u65e5\u671f\uff0c\u8fd4\u56de: String", new Variable("start", String.class), new Variable("cycle", String.class), new Variable("handDate", String.class)));
        pluginsTemplates.add(new Template("dateTools.isLastYear(\u65e5\u671f\u4e32)", "dateTools.isLastYear($value$)", "\u6bd4\u8f83\u6307\u5b9a\u65e5\u671f\u548c\u5f53\u524d\u65e5\u671f\u7684\u5e74\u4efd\uff0c\u8fd4\u56de: Boolean(a>=b)", new Variable("value", String.class)));
        pluginsTemplates.add(new Template("dateTools.getDiffDate(\u64cd\u4f5c\u7c7b\u578b, \u5dee\u503c, \u76ee\u6807\u65e5\u671f\u683c\u5f0f)", "dateTools.getDiffDate($type$, $param$, $format$)", "\u6839\u636e\u64cd\u4f5c\u7c7b\u578b\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u7684\u524d\u540e\u65e5\u671f\uff0c\u8fd4\u56de: String", new Variable("type", String.class), new Variable("param", String.class), new Variable("format", String.class)));
        pluginsTemplates.add(new Template("dateTools.getDelayDate(\u65e5\u671f\u4e32, \u64cd\u4f5c\u7c7b\u578b, \u5dee\u503c)", "dateTools.getDelayDate($date$, $type$, $param$)", "\u6839\u636e\u64cd\u4f5c\u7c7b\u578b\u83b7\u53d6\u6307\u5b9a\u65e5\u671f\u7684\u524d\u540e\u65e5\u671f\uff0c\u8fd4\u56de: String", new Variable("date", String.class), new Variable("type", String.class), new Variable("param", String.class)));
        pluginsTemplates.add(new Template("dateTools.getDateBetween(\u65e5\u671f\u4e321, \u65e5\u671f\u4e322)", "dateTools.getDateBetween($date1$, $date2$)", "\u83b7\u53d6\u4e24\u4e2a\u65f6\u95f4\u7684\u76f8\u5dee\u6beb\u79d2\u6570\uff0c\u7edd\u5bf9\u503c\uff0c\u8fd4\u56de: String", new Variable("date1", String.class), new Variable("date2", String.class)));
        pluginsTemplates.add(new Template("dateTools.getDateDayBetween(\u65e5\u671f\u4e321, \u65e5\u671f\u4e322, \u662f\u5426\u5ffd\u7565\u65f6\u5206\u79d2)", "dateTools.getDateDayBetween($date1$, $date2$, $isReset$)", "\u83b7\u53d6\u4e24\u4e2a\u65f6\u95f4\u7684\u5929\u6570\u76f8\u5dee\u95f4\u9694\uff0c\u7edd\u5bf9\u503c\uff0c\u8fd4\u56de: String", new Variable("date1", String.class), new Variable("date2", String.class), new Variable("isReset", Boolean.class)));
        pluginsTemplates.add(new Template("restTools.post(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53, \u8bf7\u6c42\u5934)", "restTools.post($url$, $value$, $header$)", "POST\u8bf7\u6c42\uff0c\u8fd4\u56de: String", new Variable("url", String.class), new Variable("value", String.class), new Variable("header", String.class)));
        pluginsTemplates.add(new Template("restTools.post(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53)", "restTools.post($url$, $value$)", "POST\u8bf7\u6c42\uff0c\u8fd4\u56de: String", new Variable("url", String.class), new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("restTools.postByFormData(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53, \u8bf7\u6c42\u5934)", "restTools.postByFormData($url$, $value$, $header$)", "POST\u8bf7\u6c42\uff0cform-data\u683c\u5f0f\uff0c\u8fd4\u56de: String", new Variable("url", String.class), new Variable("value", String.class), new Variable("header", String.class)));
        pluginsTemplates.add(new Template("restTools.postByFormData(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53)", "restTools.postByFormData($url$, $value$)", "POST\u8bf7\u6c42\uff0cform-data\u683c\u5f0f\uff0c\u8fd4\u56de: String", new Variable("url", String.class), new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("restTools.get(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u5934)", "restTools.get($url$, $header$)", "GET\u8bf7\u6c42\uff0c\u8fd4\u56de: String", new Variable("url", String.class), new Variable("header", String.class)));
        pluginsTemplates.add(new Template("restTools.get(\u8bf7\u6c42\u8def\u5f84)", "restTools.get($url$)", "GET\u8bf7\u6c42\uff0c\u8fd4\u56de: String", new Variable("url", String.class)));
        pluginsTemplates.add(new Template("restTools.put(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53, \u8bf7\u6c42\u5934)", "restTools.put($url$, $value$, $header$)", "PUT\u8bf7\u6c42\uff0c\u8fd4\u56de: String", new Variable("url", String.class), new Variable("value", String.class), new Variable("header", String.class)));
        pluginsTemplates.add(new Template("restTools.put(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53)", "restTools.put($url$, $value$)", "PUT\u8bf7\u6c42\uff0c\u8fd4\u56de: String", new Variable("url", String.class), new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("restTools.delete(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53, \u8bf7\u6c42\u5934)", "restTools.delete($url$, $value$, $header$)", "DELETE\u8bf7\u6c42\uff0c\u8fd4\u56de: String", new Variable("url", String.class), new Variable("value", String.class), new Variable("header", String.class)));
        pluginsTemplates.add(new Template("restTools.delete(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53)", "restTools.delete($url$, $value$)", "DELETE\u8bf7\u6c42\uff0c\u8fd4\u56de: String", new Variable("url", String.class), new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("restTools.formatURL(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53)", "restTools.formatURL($url$, $params$)", "URL\u62fc\u63a5\u8bf7\u6c42\u53c2\u6570\uff0c\u8fd4\u56de: String", new Variable("url", String.class), new Variable("params", JSONObject.class)));
        pluginsTemplates.add(new Template("restTools.formatAndEncodeURL(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53)", "restTools.formatAndEncodeURL($url$, $params$)", "URL\u62fc\u63a5URLEncode\u7f16\u7801\u7684\u8bf7\u6c42\u53c2\u6570\uff0c\u8fd4\u56de: String", new Variable("url", String.class), new Variable("params", JSONObject.class)));
        pluginsTemplates.add(new Template("restAsyncTools.post(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53)", "restAsyncTools.post($url$, $value$)", "POST\u5f02\u6b65\u8bf7\u6c42\uff0c\u8fd4\u56de: void", new Variable("url", String.class), new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("restAsyncTools.get(\u8bf7\u6c42\u8def\u5f84)", "restAsyncTools.get($url$)", "GET\u5f02\u6b65\u8bf7\u6c42\uff0c\u8fd4\u56de: void", new Variable("url", String.class)));
        pluginsTemplates.add(new Template("restAsyncTools.put(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53)", "restAsyncTools.put($url$, $value$)", "PUT\u5f02\u6b65\u8bf7\u6c42\uff0c\u8fd4\u56de: void", new Variable("url", String.class), new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("restAsyncTools.delete(\u8bf7\u6c42\u8def\u5f84, \u8bf7\u6c42\u4f53)", "restAsyncTools.delete($url$, $value$)", "DELETE\u5f02\u6b65\u8bf7\u6c42\uff0c\u8fd4\u56de: void", new Variable("url", String.class), new Variable("value", JSONObject.class)));
        pluginsTemplates.add(new Template("ioTools.hasResource(\u6587\u4ef6\u8def\u5f84)", "ioTools.hasResource($path$)", "\u5224\u65ad\u6587\u4ef6\u662f\u5426\u5b58\u5728\uff0c\u8fd4\u56de: Boolean", new Variable("path", String.class)));
        pluginsTemplates.add(new Template("ioTools.readText(\u6587\u4ef6\u8def\u5f84)", "ioTools.readText($path$)", "\u83b7\u53d6\u6587\u672c\u5185\u5bb9\uff0c\u8fd4\u56de: String", new Variable("path", String.class)));
        pluginsTemplates.add(new Template("jsonTools.addJSON(\u88ab\u8ffd\u52a0\u7684JSON\u5bf9\u8c61, \u8ffd\u52a0\u7684JSON\u5bf9\u8c61)", "jsonTools.addJSON($a$, $b$)", "\u7ed9JSON\u5bf9\u8c61\u8ffd\u52a0\u76ee\u6807JSON\u5bf9\u8c61\u7684\u6240\u6709\u6210\u5458\uff0c\u8fd4\u56de: JSONObject", new Variable("a", JSONObject.class), new Variable("b", JSONObject.class)));
        pluginsTemplates.add(new Template("jsonTools.convertToJson(JSON\u5b57\u7b26\u4e32)", "jsonTools.convertToJson($str$)", "\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3aJSON\u5bf9\u8c61\uff0c\u8fd4\u56de: JSONObject", new Variable("str", String.class)));
        pluginsTemplates.add(new Template("jsonTools.parseArray(JSON\u5b57\u7b26\u4e32)", "jsonTools.parseArray($str$)", "\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3aJSON\u96c6\u5408\uff0c\u8fd4\u56de: JSONArray", new Variable("str", String.class)));
        pluginsTemplates.add(new Template("jsonTools.getArray()", "jsonTools.getArray()", "\u83b7\u53d6\u4e00\u4e2aJSON\u96c6\u5408\u5bf9\u8c61\uff0c\u8fd4\u56de: JSONArray", new Variable[0]));
        pluginsTemplates.add(new Template("jsonTools.getArray(\u957f\u5ea6)", "jsonTools.parseArray($num$)", "\u83b7\u53d6\u4e00\u4e2a\u6307\u5b9a\u957f\u5ea6\u7684JSON\u96c6\u5408\u5bf9\u8c61\uff0c\u8fd4\u56de: JSONArray", new Variable("num", Object.class)));
        pluginsTemplates.add(new Template("jsonTools.replaceJSON(\u88ab\u66ff\u6362\u7684JSON\u5bf9\u8c61, \u66ff\u6362\u7684JSON\u5bf9\u8c61)", "jsonTools.replaceJSON($a$, $b$)", "JSON\u952e\u503c\u5bf9\u66ff\u6362\uff08\u4fdd\u7559\u539fJSON\u4e2d\u7684\u952e\u503c\u5bf9\uff09\uff0c\u8fd4\u56de: JSONObject", new Variable("a", JSONObject.class), new Variable("b", JSONObject.class)));
        pluginsTemplates.add(new Template("jsonTools.readJsonFile(\u6587\u4ef6\u8def\u5f84)", "jsonTools.readJsonFile($path$)", "\u8bfb\u53d6JSON\u6587\u4ef6\uff0c\u8fd4\u56deJSON\u5bf9\u8c61\uff0c\u8fd4\u56de: JSONObject", new Variable("path", String.class)));
        pluginsTemplates.add(new Template("jsonTools.readJsonArrayFile(\u6587\u4ef6\u8def\u5f84)", "jsonTools.readJsonArrayFile($path$)", "\u8bfb\u53d6JSON\u6587\u4ef6\uff0c\u8fd4\u56deJSON\u96c6\u5408\u5bf9\u8c61\uff0c\u8fd4\u56de: JSONArray", new Variable("path", String.class)));
        pluginsTemplates.add(new Template("jsonTools.formatJsonByParams(JSON\u5bf9\u8c61, \u53c2\u6570\u5b57\u5178)", "jsonTools.formatJsonByParams($object$, $params$)", "\u6839\u636e\u53c2\u6570\u5b57\u5178\u683c\u5f0f\u5316Json\uff0c\u8fd4\u56de: JSONObject", new Variable("object", JSONObject.class), new Variable("params", JSONObject.class)));
        pluginsTemplates.add(new Template("jsonTools.formatJsonArrayByParams(JSON\u5bf9\u8c61, \u53c2\u6570\u5b57\u5178)", "jsonTools.formatJsonArrayByParams($object$, $params$)", "\u6839\u636e\u53c2\u6570\u5b57\u5178\u683c\u5f0f\u5316JSON\u96c6\u5408\uff0c\u8fd4\u56de: JSONArray", new Variable("object", JSONObject.class), new Variable("params", JSONObject.class)));
        TemplateGroup plugins = new TemplateGroup("af-common-plugins", "af-common-plugins", pluginsTemplates);
        ArrayList<Template> expressionTemplates = new ArrayList<Template>();
        expressionTemplates.add(new Template("for", "$object$.each(\n    $body$\n)\n", "For\u5faa\u73af", new Variable("object"), new Variable("body")));
        expressionTemplates.add(new Template("if", "$expression$ :(\n     $body$\n),null\n", "if\u5224\u65ad", new Variable("expression"), new Variable("body")));
        expressionTemplates.add(new Template("if...else", "$expression$ :(\n    $body$\n),(\n    $body2$\n)\n", "if...else\u5224\u65ad", new Variable("expression"), new Variable("body"), new Variable("body2")));
        expressionTemplates.add(new Template("if...else if...else", "$expression$ :(\n    $body$\n),\n$expression2$ :(\n    $body2$\n),\n(\n    $body3$\n)\n", "\u591a\u91cdif\u5224\u65ad", new Variable("expression"), new Variable("body"), new Variable("expression2"), new Variable("body2"), new Variable("body3")));
        expressionTemplates.add(new Template("json", "$jsonName$ = {\n    $body$\n}\n", "\u521b\u5efaJSON\u5bf9\u8c61", new Variable("jsonName"), new Variable("body")));
        expressionTemplates.add(new Template("jsonArray", "$jsonArrayName$ = [\n    $body$\n]\n", "\u521b\u5efaJSONArray\u5bf9\u8c61", new Variable("jsonArrayName"), new Variable("body")));
        TemplateGroup expression = new TemplateGroup("af-common-expression", "af-common-expression", expressionTemplates);
        TEMPLATE_GROUP_LIST = new ArrayList<TemplateGroup>();
        TEMPLATE_GROUP_LIST.add(core);
        TEMPLATE_GROUP_LIST.add(plugins);
        TEMPLATE_GROUP_LIST.add(expression);
    }
}

