package com.af.v4.system.common.plugins.calculate;

import com.af.v4.system.common.plugins.core.PriceFormatTools;
import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * caption 混合单价计算。 费用 = 气量*混合单价1比例*混合单价1 + 气量*混合单价2比例*混合单价2
 *
 * @author Lyf
 */
public class MixedpriceSettlement implements ISettlementInterface {

    @Override
    public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
        //价格1单价
        BigDecimal hybridprice1 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice1")));
        //价格2单价
        BigDecimal hybridprice2 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice2")));
        //价格1比例
        BigDecimal hybridprice1rate = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice1rate")));

        //费用 = 气量*混合单价1比例*混合单价1 + 气量*混合单价2比例*混合单价2
        BigDecimal gas1 = gas.multiply(hybridprice1rate);
        BigDecimal gas2 = new BigDecimal("1").subtract(hybridprice1rate).multiply(gas);
        BigDecimal chargenum1 = gas1.multiply(hybridprice1);
        BigDecimal chargenum2 = gas2.multiply(hybridprice2);
        PriceFormatTools.formatNumberBase(chargenum1);
        PriceFormatTools.formatNumberBase(chargenum2);
        BigDecimal chargenum = chargenum1.add(chargenum2);

        JSONArray array = new JSONArray();
        //目前只支持两种
        JSONObject json = new JSONObject();
        json.put("f_price_name", "混合1");
        json.put("f_price", hybridprice1);
        json.put("f_gas", gas1);
        json.put("f_money", chargenum1);
        array.put(json);
        JSONObject json2 = new JSONObject();
        json2.put("f_price_name", "混合2");
        json2.put("f_price", hybridprice2);
        json2.put("f_gas", gas2);
        json2.put("f_money", chargenum2);
        array.put(json2);

        JSONObject ret = new JSONObject();
        ret.put("chargeprice", array);
        ret.put("chargenum", chargenum);
        return ret;
    }

    @Override
    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
        //价格1单价
        BigDecimal hybridprice1 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get(
                "f_hybridprice1")));
        //价格2单价
        BigDecimal hybridprice2 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get(
                "f_hybridprice2")));
        //价格1比例
        BigDecimal hybridprice1rate = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0)
                .get("f_hybridprice1rate")));

        BigDecimal amount = fee.divide(
                hybridprice1rate.multiply(hybridprice1).add(
                        new BigDecimal("1").subtract(hybridprice1rate).multiply(
                                hybridprice2)), 0, RoundingMode.DOWN);

        JSONArray array = new JSONArray();
        //目前只支持两种
        JSONObject json = new JSONObject();
        json.put("f_price_name", "混合1");
        json.put("f_price", hybridprice1);
        json.put("f_gas", amount);
        json.put("f_money", fee);
        array.put(json);
        JSONObject json2 = new JSONObject();
        json2.put("f_price_name", "混合2");
        json2.put("f_price", hybridprice2);
        json2.put("f_gas", amount);
        json2.put("f_money", fee);
        array.put(json2);

        JSONObject ret = new JSONObject();
        ret.put("chargeprice", array);
        ret.put("gas", amount);
        //格式化数字类型
        PriceFormatTools.formatNumber(ret);
        return ret;
    }
}
