/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.http.core;

import com.af.v4.system.common.plugins.http.config.HttpClientConfig;
import com.af.v4.system.common.plugins.http.config.HttpRuntimeSupport;
import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.message.BasicHeaderElementIterator;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionPoolUtil
extends BaseHttpPoolUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConnectionPoolUtil.class);
    private static final Object SYNC_LOCK = new Object();
    private static volatile CloseableHttpClient httpClient;

    public static CloseableHttpClient getHttpClient(LayeredConnectionSocketFactory sslSocketFactory) {
        return HttpConnectionPoolUtil.createHttpClient(sslSocketFactory);
    }

    private static CloseableHttpClient createHttpClient() {
        return HttpConnectionPoolUtil.createHttpClient(null);
    }

    private static CloseableHttpClient createHttpClient(LayeredConnectionSocketFactory sslSocketFactory) {
        if (sslSocketFactory == null) {
            try {
                sslSocketFactory = new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(registry);
        manager.setMaxTotal(HttpClientConfig.HTTP_MAX_POOL_SIZE.intValue());
        manager.setDefaultMaxPerRoute(HttpClientConfig.HTTP_MAX_POOL_SIZE.intValue());
        ConnectionKeepAliveStrategy myStrategy = (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = (HeaderElement)it.next();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !"timeout".equalsIgnoreCase(param)) continue;
                try {
                    return TimeValue.ofSeconds((long)(Long.parseLong(value) * 1000L));
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return TimeValue.ofSeconds((long)5000L);
        };
        HttpClientConfig config = new HttpClientConfig.Builder().build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)config.getConnectTimeout().intValue())).setConnectTimeout(Timeout.ofSeconds((long)config.getConnectTimeout().intValue())).setResponseTimeout(Timeout.ofSeconds((long)config.getSocketTimeout().intValue())).build();
        return HttpClients.custom().setKeepAliveStrategy(myStrategy).setConnectionManagerShared(true).setConnectionManager((HttpClientConnectionManager)manager).setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(0, TimeValue.ofSeconds((long)1L))).evictExpiredConnections().evictIdleConnections(TimeValue.ofMilliseconds((long)HttpClientConfig.HTTP_IDEL_TIME_OUT.intValue())).setDefaultRequestConfig(requestConfig).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient getHttpClient() {
        if (httpClient == null) {
            Object object = SYNC_LOCK;
            synchronized (object) {
                if (httpClient == null) {
                    httpClient = HttpConnectionPoolUtil.createHttpClient();
                }
            }
        }
        return httpClient;
    }

    public static String request(String value, String headersStr, HttpClientConfig config, Boolean isStandardResponse, HttpUriRequestBase base) {
        return HttpConnectionPoolUtil.request(value, headersStr, config, base, isStandardResponse, null);
    }

    public static String request(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base) {
        return HttpConnectionPoolUtil.request(value, headersStr, config, false, base);
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, Boolean isStandardResponse, HttpUriRequestBase base) {
        return HttpConnectionPoolUtil.requestFormUrlEncoded(value, headersStr, config, base, isStandardResponse, null);
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base) {
        return HttpConnectionPoolUtil.requestFormUrlEncoded(value, headersStr, config, false, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base, Boolean isStandardResponse, CloseableHttpClient httpClient) {
        String url = base.getScheme() + "://" + String.valueOf(base.getAuthority()) + base.getPath();
        if (httpClient == null) {
            httpClient = HttpConnectionPoolUtil.getHttpClient();
        }
        HttpConnectionPoolUtil.setRequestConfig(config, base);
        HttpConnectionPoolUtil.setHeaders((HttpRequest)base, headersStr);
        if (base.getEntity() == null) {
            HttpConnectionPoolUtil.setBody((HttpRequest)base, value);
        }
        String result = "";
        long begin = System.currentTimeMillis();
        try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)base, (HttpContext)HttpClientContext.create());){
            Header[] headerArray;
            String body = HttpConnectionPoolUtil.getResponseData(begin, (HttpResponse)response);
            JSONObject headerObject = new JSONObject();
            for (Header header : headerArray = response.getHeaders()) {
                headerObject.put(header.getName(), (Object)header.getValue());
            }
            result = isStandardResponse.booleanValue() ? new JSONObject().put("body", (Object)body).put("header", (Object)headerObject).toString() : body;
        }
        catch (IOException | ParseException e) {
            try {
                int code = e instanceof HttpHostConnectException | e instanceof ConnectTimeoutException ? 504 : 503;
                JSONObject errorResult = new JSONObject();
                errorResult.put("hasError", true);
                errorResult.put("code", code);
                errorResult.put("msg", (Object)e.getMessage());
                result = errorResult.toString();
            }
            catch (Throwable throwable) {
                boolean disableLogPrint = HttpRuntimeSupport.getDisableLogPrintValue();
                if (!disableLogPrint) {
                    LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0cresponse: {}\uff0ctype: sync", new Object[]{url, headersStr, value, result});
                }
                throw throwable;
            }
            boolean disableLogPrint = HttpRuntimeSupport.getDisableLogPrintValue();
            if (!disableLogPrint) {
                LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0cresponse: {}\uff0ctype: sync", new Object[]{url, headersStr, value, result});
            }
        }
        boolean disableLogPrint = HttpRuntimeSupport.getDisableLogPrintValue();
        if (!disableLogPrint) {
            LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0cresponse: {}\uff0ctype: sync", new Object[]{url, headersStr, value, result});
        }
        return result;
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base, Boolean isStandardResponse, CloseableHttpClient httpClient) {
        HttpConnectionPoolUtil.setUrlEncodedBody((ClassicHttpRequest)base, value);
        return HttpConnectionPoolUtil.request(value, headersStr, config, base, isStandardResponse, httpClient);
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base, CloseableHttpClient httpClient) {
        return HttpConnectionPoolUtil.requestFormUrlEncoded(value, headersStr, config, base, false, httpClient);
    }
}

