package com.af.v4.system.common.plugins.core;

import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Iterator;

/**
 * 金额格式化工具类
 *
 * @author Mr.river
 */
public class PriceFormatTools {
    static final NumberFormat NF;

    static {
        NF = NumberFormat.getInstance();
        NF.setGroupingUsed(false);
        // 最小有效位数: 2
        NF.setMinimumFractionDigits(2);
        // 最大有效位数: 4
        NF.setMaximumFractionDigits(4);
    }

    /**
     * jsonObject 批量格式化
     *
     * @param object 待格式化 {@code jsonObject} 对象
     */
    public static void formatNumber(JSONObject object) {
        Iterator<String> iterator = object.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = object.get(key);
            if (value instanceof BigDecimal) {
                object.put(key, formatNumberBase(value));
            } else if (value instanceof JSONObject) {
                formatNumber((JSONObject) value);
            } else if (value instanceof JSONArray) {
                formatNumber((JSONArray) value);
            }
        }
    }

    /**
     * jsonArray批量格式化
     *
     * @param object 待格式化 {@code jsonArray} 对象
     */
    public static void formatNumber(JSONArray object) {
        Iterator<Object> iterator = object.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value instanceof BigDecimal) {
                object.put(index, formatNumberBase(value));
            } else if (value instanceof JSONObject) {
                formatNumber((JSONObject) value);
            } else if (value instanceof JSONArray) {
                formatNumber((JSONArray) value);
            }
            index++;
        }
    }

    /**
     * 格式化对象 - 会把所有的对象转化为字符串 - 不建议使用
     *
     * @param value 待格式化对象
     * @return 格式化字符串
     */
    public static String formatNumberBase(Object value) {
        return NF.format(value);
    }
}
