/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.http.core.response;

import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAsyncResponse
implements FutureCallback<SimpleHttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(StandardAsyncResponse.class);
    final long begin = System.currentTimeMillis();
    private final SuccessHandler successHandler;
    private final ErrorHandler errorHandler;

    public StandardAsyncResponse(SuccessHandler successHandler, ErrorHandler errorHandler) {
        this.successHandler = successHandler;
        this.errorHandler = errorHandler;
    }

    public StandardAsyncResponse(SuccessHandler successHandler) {
        this.successHandler = successHandler;
        this.errorHandler = e -> logger.error("\u5f02\u6b65\u8bf7\u6c42\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
    }

    public void completed(SimpleHttpResponse response) {
        try {
            String result = BaseHttpPoolUtil.getResponseData(this.begin, (HttpResponse)response);
            this.successHandler.run(result);
        }
        catch (Exception e) {
            this.failed(e);
        }
    }

    public void failed(Exception ex) {
        this.errorHandler.run(ex);
    }

    public void cancelled() {
    }

    public static interface SuccessHandler {
        public void run(String var1);
    }

    public static interface ErrorHandler {
        public void run(Exception var1);
    }
}

