package com.af.v4.system.common.plugins.http.core.response;

import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 标准异步响应实现
 *
 * @author Mr.river
 * @apiNote 自行根据成功和失败的响应处理
 */
public class StandardAsyncResponse implements FutureCallback<SimpleHttpResponse> {

    private static final Logger logger = LoggerFactory.getLogger(StandardAsyncResponse.class);

    final long begin = System.currentTimeMillis();

    private final SuccessHandler successHandler;

    private final ErrorHandler errorHandler;

    public StandardAsyncResponse(SuccessHandler successHandler, ErrorHandler errorHandler) {
        this.successHandler = successHandler;
        this.errorHandler = errorHandler;
    }

    public StandardAsyncResponse(SuccessHandler successHandler) {
        this.successHandler = successHandler;
        this.errorHandler = e -> logger.error("异步请求时发生异常：", e);
    }


    @Override
    public void completed(SimpleHttpResponse response) {
        String result;
        try {
            result = BaseHttpPoolUtil.getResponseData(begin, response);
            successHandler.run(result);
        } catch (Exception e) {
            this.failed(e);
        }
    }

    @Override
    public void failed(Exception ex) {
        errorHandler.run(ex);
    }

    @Override
    public void cancelled() {

    }

    public interface SuccessHandler {
        void run(String response);
    }

    public interface ErrorHandler {
        void run(Exception e);
    }
}
