package com.af.v4.system.common.plugins.http.config;

import java.util.Objects;

/**
 * SQL运行时支持
 */
public class HttpRuntimeSupport {
    /**
     * 禁用日志输出
     */
    private static final ThreadLocal<Boolean> disableLogPrintThreadLocal = new ThreadLocal<>();


    public static boolean getDisableLogPrintValue() {
        Boolean yn = disableLogPrintThreadLocal.get();
        return Objects.requireNonNullElse(yn, false);
    }

    public static void disableLogPrint() {
        disableLogPrintThreadLocal.set(true);
    }

    public static void enableLogPrint() {
        disableLogPrintThreadLocal.remove();
    }
}
