/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.json;

import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.plugins.io.IOTools;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

public class JsonTools {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static JSONObject addJSON(JSONObject obj, JSONObject addObj) {
        if (addObj == null) {
            throw new NullPointerException("\u8ffd\u52a0\u7684JSONObject\u4e0d\u5b58\u5728\uff01");
        }
        Set keys = addObj.keySet();
        for (String key : keys) {
            JSONObject cloneItem;
            Object item = addObj.get(key);
            if (item instanceof JSONObject) {
                JSONObject json = (JSONObject)item;
                cloneItem = new JSONObject(json.toMap());
                obj.put(key, (Object)cloneItem);
                continue;
            }
            if (item instanceof JSONArray) {
                JSONArray array = (JSONArray)item;
                cloneItem = new JSONArray((Collection)array.toList());
                obj.put(key, (Object)cloneItem);
                continue;
            }
            obj.put(key, item);
        }
        return obj;
    }

    public static JSONObject convertToJson(String str) {
        if (str == null || str.isEmpty()) {
            return new JSONObject();
        }
        return new JSONObject(str);
    }

    public static JSONObject convertToJson(JSONObject json) {
        return json;
    }

    public static JSONObject xmlConvertToJson(String xmlStr) {
        if (xmlStr == null || xmlStr.isEmpty()) {
            return new JSONObject();
        }
        return XML.toJSONObject((String)xmlStr);
    }

    public static JSONArray parseArray(String str) {
        return new JSONArray(str);
    }

    public static JSONArray parseArray(JSONArray json) {
        return json;
    }

    public static JSONArray getArray() {
        return new JSONArray();
    }

    public static JSONArray getArray(Object val) {
        int len = Integer.parseInt(val.toString());
        return new JSONArray((Object)new String[len]);
    }

    public static JSONObject getJson() {
        return new JSONObject();
    }

    public static JSONObject replaceJSON(JSONObject oldObj, JSONObject newObj) {
        for (String key : newObj.keySet()) {
            oldObj.put(key, newObj.get(key));
        }
        return oldObj;
    }

    public static JSONObject readJsonFile(String path) {
        return new JSONObject(IOTools.readText(path));
    }

    public static JSONArray readJsonArrayFile(String path) {
        return new JSONArray(IOTools.readText(path));
    }

    public static JSONObject formatJsonByParams(JSONObject object, JSONObject params) {
        if (!object.isEmpty()) {
            return new JSONObject(CommonTools.formatStrByParams(object.toString(), params));
        }
        return object;
    }

    public static JSONArray formatJsonArrayByParams(JSONArray array, JSONObject params) {
        if (!array.isEmpty()) {
            return new JSONArray(CommonTools.formatStrByParams(array.toString(), params));
        }
        return array;
    }

    public static <T> T toParse(JSONObject json, Class<T> obj) throws JsonProcessingException {
        return JsonTools.toParse(json.toString(), obj);
    }

    public static <T> T toParse(String json, Class<T> obj) throws JsonProcessingException {
        return (T)objectMapper.readValue(json, obj);
    }

    public static <T> List<T> toParseList(JSONArray json, Class<T> obj) throws JsonProcessingException {
        return (List)objectMapper.readValue(json.toString(), JsonTools.getCollectionType(List.class, obj));
    }

    public static JSONObject toJSON(Object entity) throws JsonProcessingException {
        return new JSONObject(objectMapper.writeValueAsString(entity));
    }

    public static <T> JSONArray toJsonArray(List<T> entity) throws JsonProcessingException {
        return new JSONArray(objectMapper.writeValueAsString(entity));
    }

    private static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static <T> JSONObject objToJson(T obj) throws JsonProcessingException {
        return new JSONObject(objectMapper.writeValueAsString(obj));
    }

    public static JSONArray packSettleJson(JSONObject json, String priceType) {
        JSONArray result = new JSONArray();
        if ("fixed".equals(priceType)) {
            JSONObject value = new JSONObject();
            value.put("f_unitprice", (Object)new BigDecimal(String.valueOf(json.get("f_unitprice"))));
            result.put((Object)value);
        } else if ("mixed".equals(priceType)) {
            JSONArray array = json.getJSONArray("detailprice");
            JSONObject obj = new JSONObject();
            obj.put("f_hybridprice1", (Object)new BigDecimal(String.valueOf(array.getJSONObject(0).get("f_price"))));
            obj.put("f_hybridprice2", (Object)new BigDecimal(String.valueOf(array.getJSONObject(1).get("f_price"))));
            obj.put("f_hybridprice1rate", (Object)new BigDecimal(String.valueOf(array.getJSONObject(0).get("f_ratio"))));
            result.put((Object)obj);
        } else if ("staired".equals(priceType)) {
            JSONArray array = json.getJSONArray("detailprice");
            for (Object object : array) {
                JSONObject obj = new JSONObject();
                obj.put("price", (Object)new BigDecimal(String.valueOf(((JSONObject)object).get("f_price"))));
                obj.put("amount", (Object)new BigDecimal(String.valueOf(((JSONObject)object).get("f_amount"))));
                result.put((Object)obj);
            }
            Iterator obj = new JSONObject();
            obj.put("sumamount", json.get("sumamount"));
            result.put((Object)obj);
        }
        return result;
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

