/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.date;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.util.StrUtil;
import java.util.Calendar;
import java.util.Date;

public class DateTools {
    public static Date getNow() {
        return DateUtil.date();
    }

    public static String getNow2() {
        return DateUtil.now();
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static String getNow(String format) {
        return DateUtil.date().toString(format);
    }

    public static String getNowYear() {
        return String.valueOf(DateUtil.thisYear());
    }

    public static String getNowMonth() {
        return String.valueOf(DateTools.getNowMonthAsInt());
    }

    public static int getNowMonthAsInt() {
        return DateUtil.thisMonth() + 1;
    }

    public static String getNowDay() {
        return String.valueOf(DateUtil.thisDayOfMonth());
    }

    public static String getNowDayOfWeek() {
        int value = DateUtil.thisDayOfWeek() - 1;
        if (value == 0) {
            value = 7;
        }
        return String.valueOf(value);
    }

    public static int getMonth(String date) {
        return DateUtil.parse((CharSequence)date).month() + 1;
    }

    public static int getDate(String date) {
        return DateUtil.parse((CharSequence)date).dayOfMonth();
    }

    public static String getYearMonth(String date) {
        return DateUtil.parse((CharSequence)date).toString((DatePrinter)DatePattern.SIMPLE_MONTH_FORMAT);
    }

    public static String format(String datetime, String format) {
        return DateUtil.parse((CharSequence)datetime).toString(format);
    }

    public static String formatDateTime(String datetime) {
        return DateTools.format(datetime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatDateTime(String dateStr, String format) {
        return DateUtil.parse((CharSequence)dateStr, (String)format).toString();
    }

    public static String formatDateTime(String dateStr, String format, String newFormat) {
        return DateUtil.parse((CharSequence)dateStr, (String)format).toString(newFormat);
    }

    public static boolean compareDate(String dateStr1, String dateStr2) {
        return DateUtil.compare((Date)DateUtil.parse((CharSequence)dateStr1), (Date)DateUtil.parse((CharSequence)dateStr2)) >= 0;
    }

    public static boolean compareFormatDate(String dateStr1, String dateStr2, String formatStr) {
        return DateUtil.compare((Date)DateUtil.parse((CharSequence)dateStr1, (String)formatStr), (Date)DateUtil.parse((CharSequence)dateStr2, (String)formatStr)) >= 0;
    }

    public static String getStartDate(String date, String type, String format) {
        if (StrUtil.isBlank((CharSequence)date) || StrUtil.isBlank((CharSequence)type)) {
            throw new RuntimeException("\u83b7\u53d6\u5f00\u59cb\u65f6\u95f4: \u60a8\u6240\u4f20\u7684\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01\uff01");
        }
        DateTime dateTime = DateUtil.parse((CharSequence)date);
        if ("month".equalsIgnoreCase(type)) {
            return DateUtil.beginOfMonth((Date)dateTime).toString(format);
        }
        if ("year".equalsIgnoreCase(type)) {
            return DateUtil.beginOfYear((Date)dateTime).toString(format);
        }
        return DateUtil.beginOfDay((Date)dateTime).toString(format);
    }

    public static String getStartDate(String date, String type) {
        return DateTools.getStartDate(date, type, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getEndDate(String date, String type, String format) {
        if (StrUtil.isBlank((CharSequence)date) || StrUtil.isBlank((CharSequence)type)) {
            throw new RuntimeException("\u83b7\u53d6\u6700\u540e\u65f6\u95f4: \u60a8\u6240\u4f20\u7684\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01\uff01");
        }
        DateTime dateTime = DateUtil.parse((CharSequence)date);
        if ("month".equalsIgnoreCase(type)) {
            return DateUtil.endOfMonth((Date)dateTime).toString(format);
        }
        if ("year".equalsIgnoreCase(type)) {
            return DateUtil.endOfYear((Date)dateTime).toString(format);
        }
        return DateUtil.endOfDay((Date)dateTime).toString(format);
    }

    public static String getEndDate(String date, String type) {
        return DateTools.getEndDate(date, type, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getStairStartDate(String start, Object cycle, String handDate) throws Exception {
        boolean isLowerDay;
        if ("".equals(start) || start == null) {
            throw new Exception("\u9636\u68af\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!!");
        }
        if (cycle == null) {
            throw new Exception("\u9636\u68af\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a!!");
        }
        if ("".equals(handDate) || handDate == null) {
            throw new Exception("\u6284\u8868\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!!");
        }
        Calendar now = Calendar.getInstance();
        if (start.length() > 5) {
            start = start.substring(5, 10);
        }
        String[] str = start.split("-");
        int beginMonth = Integer.parseInt(str[0]);
        int nowMonth = DateTools.getMonth(handDate);
        if (DateTools.isLastYear(handDate)) {
            now.set(1, now.get(1) - 1);
        } else {
            now.set(1, now.get(1));
        }
        now.set(5, Integer.parseInt(str[1]));
        int a = (nowMonth + (12 - beginMonth)) % Integer.parseInt(cycle.toString());
        boolean bl = isLowerDay = Calendar.getInstance().get(5) - Integer.parseInt(str[1]) < 0;
        int month = isLowerDay ? (a == 0 ? a - (Integer)cycle : -a) : -a;
        now.add(2, month);
        return DateUtil.format((Date)now.getTime(), (DatePrinter)DatePattern.NORM_DATE_FORMAT);
    }

    private static boolean isLastYear(String date) {
        return DateUtil.parse((CharSequence)date).year() < DateUtil.date().year();
    }

    public static String getDiffDate(String type, String param, String format) {
        DateTime dateTime = DateUtil.date();
        return DateTools.getDelayDate(dateTime, type, param, format);
    }

    public static String getDelayDate(String date, String type, String param) {
        DateTime dateTime = DateUtil.parse((CharSequence)date);
        return DateTools.getDelayDate(dateTime, type, param, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getDateBetween(String date1, String date2) {
        return String.valueOf(DateUtil.betweenMs((Date)DateUtil.parse((CharSequence)date1), (Date)DateUtil.parse((CharSequence)date2)));
    }

    public static String getDateDayBetween(String date1, String date2, Boolean isReset) {
        return String.valueOf(DateUtil.betweenDay((Date)DateUtil.parse((CharSequence)date1), (Date)DateUtil.parse((CharSequence)date2), (boolean)isReset));
    }

    private static String getDelayDate(DateTime dateTime, String type, String param, String format) {
        switch (type.toUpperCase()) {
            case "YEAR": {
                dateTime.offset(DateField.YEAR, Integer.parseInt(param));
                break;
            }
            case "MONTH": {
                dateTime.offset(DateField.MONTH, Integer.parseInt(param));
                break;
            }
            case "DATE": {
                dateTime.offset(DateField.DAY_OF_MONTH, Integer.parseInt(param));
                break;
            }
            case "HOUR": {
                dateTime.offset(DateField.HOUR, Integer.parseInt(param));
                break;
            }
            case "MINUTE": {
                dateTime.offset(DateField.MINUTE, Integer.parseInt(param));
                break;
            }
            case "SECOND": {
                dateTime.offset(DateField.SECOND, Integer.parseInt(param));
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u7c7b\u578b\uff01\u53ef\u9009\u503c(YEAR,MONTH,DATE,HOUR,MINUTE,SECOND)");
            }
        }
        return dateTime.toString(format);
    }
}

