/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.calculate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberUtil {
    static final int SCALE_NUM = 4;
    private static final Logger log = LoggerFactory.getLogger(NumberUtil.class);
    private static final RoundingMode DOWN = RoundingMode.DOWN;

    public static boolean isNumeric(String str) {
        try {
            new BigDecimal(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static BigDecimal getBigDecimal(Object bigDecimal) {
        return NumberUtil.getBigDecimal(bigDecimal, 4, DOWN);
    }

    public static BigDecimal getBigDecimal(Object bigDecimal, int scaleNum, RoundingMode mode) {
        return NumberUtil.commonParse(NumberUtil.parseBigDecimal(bigDecimal), scaleNum, mode);
    }

    public static BigDecimal parseBigDecimal(Object o) {
        try {
            return new BigDecimal(String.valueOf(o));
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38, \u8bf7\u68c0\u67e5\u53c2\u6570");
            return null;
        }
    }

    public static BigDecimal commonParse(Object bigDecimal) {
        return NumberUtil.commonParse(bigDecimal, 4, DOWN);
    }

    public static BigDecimal commonParse(BigDecimal bigDecimal) {
        return NumberUtil.commonParse(bigDecimal, 4, DOWN);
    }

    public static BigDecimal commonParse(Object bigDecimal, int scaleNum, RoundingMode mode) {
        return NumberUtil.commonParse(NumberUtil.getBigDecimal(bigDecimal), scaleNum, mode);
    }

    public static BigDecimal commonParse(BigDecimal bigDecimal, int scaleNum, RoundingMode mode) {
        if (scaleNum < 0) {
            throw new IllegalArgumentException("\u6709\u6548\u4f4d\u6570\u4e0d\u80fd\u5c0f\u4e8e 0 ");
        }
        return bigDecimal.setScale(scaleNum, mode);
    }

    public static BigDecimal ceil(BigDecimal bigDecimal) {
        return NumberUtil.ceil(bigDecimal, 4);
    }

    public static BigDecimal ceil(BigDecimal bigDecimal, Integer scale) {
        return NumberUtil.commonParse(bigDecimal, (int)scale, RoundingMode.CEILING);
    }

    public static BigDecimal round(BigDecimal bigDecimal) {
        return NumberUtil.round(bigDecimal, 4);
    }

    public static BigDecimal round(BigDecimal bigDecimal, Integer scale) {
        return NumberUtil.commonParse(bigDecimal, (int)scale, RoundingMode.HALF_UP);
    }
}

