package com.af.v4.system.common.plugins.http.core.response;

import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 默认异步响应实现
 *
 * @author Mr.river
 * @apiNote 实现了对响应结果的打印
 */
public class DefaultAsyncResponse implements FutureCallback<SimpleHttpResponse> {

    private static final Logger logger = LoggerFactory.getLogger(DefaultAsyncResponse.class);

    final long begin = System.currentTimeMillis();

    @Override
    public void completed(SimpleHttpResponse response) {
        String result;
        try {
            result = BaseHttpPoolUtil.getResponseData(begin, response);
            logger.info("异步请求结果：" + result);
        } catch (Exception e) {
            this.failed(e);
        }
    }

    @Override
    public void failed(Exception ex) {
        logger.error("异步请求时发生异常：", ex);
    }

    @Override
    public void cancelled() {

    }
}
