/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.handler.impl.psbc;

import com.af.v4.system.common.payment.annotation.PaymentHandlerConfig;
import com.af.v4.system.common.payment.dto.CancelPaymentRequest;
import com.af.v4.system.common.payment.dto.CancelPaymentResponse;
import com.af.v4.system.common.payment.dto.DownloadReconciliationFileRequest;
import com.af.v4.system.common.payment.dto.DownloadReconciliationFileResponse;
import com.af.v4.system.common.payment.dto.PaymentOrderRequest;
import com.af.v4.system.common.payment.dto.PaymentOrderResponse;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusRequest;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusResponse;
import com.af.v4.system.common.payment.dto.QueryRefundStatusRequest;
import com.af.v4.system.common.payment.dto.QueryRefundStatusResponse;
import com.af.v4.system.common.payment.dto.RefundPaymentRequest;
import com.af.v4.system.common.payment.dto.RefundPaymentResponse;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.enums.PsbcStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.handler.impl.AbstractPaymentHandler;
import com.af.v4.system.common.payment.utils.FileUtils;
import com.af.v4.system.common.payment.utils.SignUtils;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.plugins.http.core.HttpConnectionPoolUtil;
import com.af.v4.system.common.plugins.json.JsonTools;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@PaymentHandlerConfig(bankName=BankName.PSBC, integrationType=IntegrationType.AGGREGATE)
public class PsbcAbstractPaymentHandlerImpl
extends AbstractPaymentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PsbcAbstractPaymentHandlerImpl.class);

    @Override
    protected JSONObject buildPayOrderRequestParams(PaymentOrderRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>>>>>>>\u5f00\u59cb\u6784\u5efa\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\uff08\u521b\u5efa\u4e8c\u7ef4\u7801\uff09");
        try {
            JSONObject head = this.getRequestHeard(paymentConfig);
            head.put("msgId", (Object)new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
            head.put("trancode", (Object)"qrcodePayOrder");
            JSONObject body = new JSONObject();
            body.put("appId", (Object)paymentConfig.getString("appId"));
            body.put("payMode", (Object)"D");
            body.put("payItemNo", (Object)paymentConfig.getString("payItemNo"));
            body.put("orderNo", (Object)request.getOrderNo());
            body.put("orderDesc", (Object)request.getDescription());
            body.put("openId", (Object)request.getUserInfoCode());
            body.put("userNo", (Object)request.getUserInfoCode());
            body.put("oweAmt", request.getAmount());
            String custom = request.getCustomParam();
            JSONObject customParam = custom != null ? new JSONObject(custom) : null;
            body.put("notifyUrl", (Object)(request.getNotifyUrl() != null ? request.getNotifyUrl() : paymentConfig.optString("notifyUrl")));
            body.put("backUrl", (Object)paymentConfig.optString("backUrl"));
            body.put("tradeTime", (Object)DateTools.getNow((String)"yyyyMMddHHmmss"));
            body.put("accessMethod", (Object)"1");
            body.put("notifyFlag", (Object)"");
            body.put("payExpire", (Object)"");
            body.put("historyFlag", (Object)"1");
            body.put("input1", (Object)"");
            body.put("input2", (Object)"");
            body.put("input3", (Object)"");
            body.put("input4", (Object)"");
            body.put("input5", (Object)"");
            JSONObject reqParams = new JSONObject();
            reqParams.put("head", (Object)head);
            reqParams.put("body", (Object)body);
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected PaymentOrderResponse processPayOrderResponse(PaymentOrderResponse response, PaymentOrderRequest request, JSONObject resultJson, JSONObject paymentConfig) {
        LOGGER.info(">>> \u5904\u7406\u652f\u4ed8\u8ba2\u5355\u54cd\u5e94\u7ed3\u679c \uff08\u521b\u5efa\u4e8c\u7ef4\u7801\uff09> ");
        try {
            PsbcStatus psbcStatus;
            String respMsg;
            JSONObject head = resultJson.optJSONObject("head");
            String respCode = head != null ? head.optString("respCode") : resultJson.optString("code");
            String string = respMsg = head != null ? head.optString("respMsg") : resultJson.optString("message");
            if (head != null) {
                String version = head.optString("version");
                String trancode = head.optString("trancode");
                String msgId = head.optString("msgId");
                String channelId = head.optString("channelId");
                LOGGER.info("\u54cd\u5e94\u5934\u4fe1\u606f - \u7248\u672c\u53f7: {}, \u4ea4\u6613\u7801: {}, \u62a5\u6587ID: {}, \u6536\u8d39\u5355\u4f4d\u4ee3\u53f7: {}", new Object[]{version, trancode, msgId, channelId});
            }
            if ((psbcStatus = PsbcStatus.fromCode(respCode)) != null && psbcStatus.isSuccess()) {
                JSONObject body = resultJson.optJSONObject("body");
                if (body != null) {
                    String qrcode = body.optString("qrcode");
                    if (!qrcode.isEmpty()) {
                        response.setPayUrl(qrcode);
                        response.setState(PaymentStatus.PAY_SUCCESS);
                        response.setNeedQuery(false);
                        response.setPayResult("\u4e8c\u7ef4\u7801\u652f\u4ed8\u8ba2\u5355\u521b\u5efa\u6210\u529f");
                        LOGGER.info("\u4e8c\u7ef4\u7801\u652f\u4ed8\u8ba2\u5355\u521b\u5efa\u6210\u529f\uff0c\u4e8c\u7ef4\u7801\u5730\u5740: {}", (Object)qrcode);
                    } else {
                        LOGGER.warn("\u54cd\u5e94\u6210\u529f\u4f46\u4e8c\u7ef4\u7801\u5730\u5740\u4e3a\u7a7a");
                        response.setState(PaymentStatus.QUERY_ORDER_FAIL);
                        response.setNeedQuery(true);
                        response.setPayResult("\u4e8c\u7ef4\u7801\u5730\u5740\u83b7\u53d6\u5931\u8d25");
                    }
                } else {
                    LOGGER.warn("\u54cd\u5e94\u6d88\u606f\u4f53\u4e3a\u7a7a");
                    response.setState(PaymentStatus.QUERY_ORDER_FAIL);
                    response.setNeedQuery(true);
                    response.setPayResult("\u54cd\u5e94\u6570\u636e\u5f02\u5e38");
                }
            } else {
                String errorMessage = "\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25";
                if (psbcStatus != null) {
                    errorMessage = psbcStatus.getMessage();
                    LOGGER.warn("\u652f\u4ed8\u8ba2\u5355\u5931\u8d25\uff0c\u9519\u8bef\u7801: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)psbcStatus.getCode(), (Object)psbcStatus.getMessage());
                } else {
                    LOGGER.warn("\u652f\u4ed8\u8ba2\u5355\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8bef\u7801: {}, \u54cd\u5e94\u4fe1\u606f: {}", (Object)respCode, (Object)respMsg);
                    errorMessage = respMsg.isEmpty() ? "\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25" : respMsg;
                }
                response.setCode(PaymentStatus.COMMUNICATION_FAIL.getCode());
                response.setMessage(errorMessage);
                response.setState(PaymentStatus.PAY_FAIL);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryPaymentStatusRequestParams(QueryPaymentStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>>>>>>>\u5f00\u59cb\u6784\u5efa\u67e5\u8be2\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570");
        try {
            JSONObject head = this.getRequestHeard(paymentConfig);
            head.put("trancode", (Object)"confirm");
            head.put("msgId", (Object)new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
            JSONObject body = new JSONObject();
            body.put("payItemNo", (Object)paymentConfig.getString("payItemNo"));
            body.put("orderNo", (Object)request.getOrderNo());
            body.put("h5PayMode", (Object)"D");
            body.put("extends1", (Object)"");
            body.put("extends2", (Object)"");
            body.put("extends3", (Object)"");
            body.put("extends4", (Object)"");
            JSONObject custom = request.getCustomParams();
            String txDate = DateTools.getNow((String)"yyyyMMdd");
            if (custom != null) {
                txDate = custom.optString("txDate", txDate);
            }
            body.put("txDate", (Object)txDate);
            JSONObject reqParams = new JSONObject();
            reqParams.put("head", (Object)head);
            reqParams.put("body", (Object)body);
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryPaymentStatusResponse processQueryPaymentStatusResponse(QueryPaymentStatusResponse response, QueryPaymentStatusRequest request, JSONObject resultJson) {
        LOGGER.info(">>> \u5904\u7406\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u54cd\u5e94\u7ed3\u679c > ");
        try {
            JSONObject head = resultJson.optJSONObject("head");
            String respCode = head != null ? head.optString("respCode") : resultJson.optString("code");
            String respMsg = head != null ? head.optString("respMsg") : resultJson.optString("message");
            PsbcStatus psbcStatus = PsbcStatus.fromCode(respCode);
            if (psbcStatus != null && psbcStatus.isSuccess()) {
                JSONObject body = resultJson.optJSONObject("body");
                if (body != null) {
                    PaymentStatus status;
                    String orderNo = body.optString("orderNo");
                    String billNo = body.optString("billNo");
                    int txAmt = body.optInt("txAmt");
                    String txTime = body.optString("txTime");
                    String orderStatus = body.optString("orderStatus");
                    response.setOrderNo(orderNo);
                    response.setTransactionId(billNo);
                    response.setAmount(txAmt);
                    switch (orderStatus) {
                        case "02": {
                            status = PaymentStatus.SUCCESS_FOR_PAYMENT;
                            response.setPaySuccessDate(DateTools.formatDateTime((String)txTime));
                            break;
                        }
                        case "01": {
                            status = PaymentStatus.PAYMENT_IN_PROGRESS;
                            break;
                        }
                        case "03": {
                            status = PaymentStatus.FAIL_FOR_PAYMENT;
                            break;
                        }
                        case "04": {
                            status = PaymentStatus.REFUND_PROCESSING;
                            break;
                        }
                        case "05": {
                            status = PaymentStatus.REFUND_SUCCESS;
                            break;
                        }
                        case "06": {
                            status = PaymentStatus.REFUND_FAIL;
                            break;
                        }
                        case "07": {
                            status = PaymentStatus.ORDER_BEEN_CLOSED;
                            break;
                        }
                        default: {
                            status = PaymentStatus.QUERY_ORDER_FAIL;
                        }
                    }
                    response.setPaymentStatus(status.getMessage());
                    response.setState(status);
                } else {
                    LOGGER.warn("\u54cd\u5e94\u6d88\u606f\u4f53\u4e3a\u7a7a");
                    response.setState(PaymentStatus.QUERY_ORDER_FAIL);
                    response.setPaymentStatus(PaymentStatus.QUERY_ORDER_FAIL.getMessage());
                }
            } else {
                String errorMessage;
                String string = errorMessage = respMsg != null && !respMsg.isEmpty() ? respMsg : "\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5931\u8d25";
                if (psbcStatus != null) {
                    errorMessage = psbcStatus.getMessage();
                    LOGGER.warn("\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5931\u8d25\uff0c\u9519\u8bef\u7801: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)psbcStatus.getCode(), (Object)psbcStatus.getMessage());
                } else {
                    LOGGER.warn("\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8bef\u7801: {}", (Object)respCode);
                }
                response.setCode(PaymentStatus.COMMUNICATION_FAIL.getCode());
                response.setMessage(errorMessage);
                response.setState(PaymentStatus.PAY_FAIL);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildCancelOrderRequestParams(CancelPaymentRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected CancelPaymentResponse processCancelOrderResponse(CancelPaymentResponse response, CancelPaymentRequest request, JSONObject resultJson) {
        return null;
    }

    @Override
    protected JSONObject buildRefundOrderRequestParams(RefundPaymentRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>>>>>>>\u5f00\u59cb\u6784\u5efa\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570");
        try {
            JSONObject head = this.getRequestHeard(paymentConfig);
            head.put("trancode", (Object)"repeatRefund");
            head.put("msgId", (Object)new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
            JSONObject body = new JSONObject();
            body.put("payItemNo", (Object)paymentConfig.getString("payItemNo"));
            body.put("orderNo", (Object)request.getOrderNo());
            body.put("outerRefundNo", (Object)request.getRefundOrderNo());
            body.put("refundReason", (Object)"\u9700\u8981\u9000\u6b3e");
            body.put("refundAmt", request.getRefundAmount());
            body.put("extends1", (Object)"");
            body.put("extends2", (Object)"");
            body.put("extends3", (Object)"");
            body.put("extends4", (Object)"");
            JSONObject reqParams = new JSONObject();
            reqParams.put("head", (Object)head);
            reqParams.put("body", (Object)body);
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u8ba2\u5355\u64a4\u9500\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected RefundPaymentResponse processRefundOrderResponse(RefundPaymentResponse response, RefundPaymentRequest request, JSONObject resultJson) {
        LOGGER.info(">>> \u5904\u7406\u9000\u6b3e\u54cd\u5e94\u7ed3\u679c > ");
        try {
            PsbcStatus psbcStatus;
            String respMsg;
            JSONObject head = resultJson.optJSONObject("head");
            String respCode = head != null ? head.optString("respCode") : resultJson.optString("code");
            String string = respMsg = head != null ? head.optString("respMsg") : resultJson.optString("message");
            if (head != null) {
                String version = head.optString("version");
                String trancode = head.optString("trancode");
                String msgId = head.optString("msgId");
                String channelId = head.optString("channelId");
                LOGGER.info("\u9000\u6b3e\u54cd\u5e94\u5934\u4fe1\u606f - \u7248\u672c\u53f7: {}, \u4ea4\u6613\u7801: {}, \u62a5\u6587ID: {}, \u6536\u8d39\u5355\u4f4d\u4ee3\u53f7: {}", new Object[]{version, trancode, msgId, channelId});
            }
            if ((psbcStatus = PsbcStatus.fromCode(respCode)) != null && psbcStatus.isSuccess()) {
                response.setOrderNo(request.getOrderNo());
                response.setRefundOrderNo(request.getRefundOrderNo());
                response.setRefundAmount(request.getRefundAmount());
                response.setState(PaymentStatus.REFUND_SUCCESS);
                response.setRefundResult("\u9000\u6b3e\u6210\u529f");
                response.setCode(PaymentStatus.REFUND_SUCCESS.getCode());
                response.setMessage(PaymentStatus.REFUND_SUCCESS.getMessage());
                LOGGER.info("\u9000\u6b3e\u5904\u7406\u6210\u529f\uff0c\u8ba2\u5355\u53f7: {}, \u9000\u6b3e\u5355\u53f7: {}, \u9000\u6b3e\u91d1\u989d: {}", new Object[]{request.getOrderNo(), request.getRefundOrderNo(), request.getRefundAmount()});
            } else {
                String errorMessage = "\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25";
                if (psbcStatus != null) {
                    errorMessage = psbcStatus.getMessage();
                    LOGGER.warn("\u9000\u6b3e\u5931\u8d25\uff0c\u9519\u8bef\u7801: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)psbcStatus.getCode(), (Object)psbcStatus.getMessage());
                } else {
                    LOGGER.warn("\u9000\u6b3e\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8bef\u7801: {}, \u54cd\u5e94\u4fe1\u606f: {}", (Object)respCode, (Object)respMsg);
                    errorMessage = respMsg != null && !respMsg.isEmpty() ? respMsg : "\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25";
                }
                response.setState(PaymentStatus.REFUND_FAIL);
                response.setRefundResult(errorMessage);
                response.setCode(PaymentStatus.REFUND_FAIL.getCode());
                response.setMessage(errorMessage);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u9000\u6b3e\u54cd\u5e94\u5f02\u5e38", (Throwable)e);
            response.setState(PaymentStatus.REFUND_FAIL);
            response.setRefundResult("\u9000\u6b3e\u5904\u7406\u5f02\u5e38");
            response.setCode(PaymentStatus.REFUND_FAIL.getCode());
            response.setMessage("\u9000\u6b3e\u5904\u7406\u5f02\u5e38");
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryRefundStatusRequestParams(QueryRefundStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>>>>>>>\u5f00\u59cb\u6784\u5efa\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u8bf7\u6c42\u53c2\u6570");
        try {
            JSONObject head = this.getRequestHeard(paymentConfig);
            head.put("trancode", (Object)"refundQuery");
            head.put("msgId", (Object)new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
            JSONObject body = new JSONObject();
            body.put("payItemNo", (Object)paymentConfig.getString("payItemNo"));
            body.put("orderNo", (Object)request.getOrderNo());
            body.put("outerRefundNo", (Object)request.getRefundId());
            body.put("extends1", (Object)"");
            body.put("extends2", (Object)"");
            body.put("extends3", (Object)"");
            body.put("extends4", (Object)"");
            JSONObject customParams = request.getCustomParams();
            String txDate = DateTools.getNow((String)"yyyyMMdd");
            if (customParams != null) {
                txDate = customParams.optString("txDate", txDate);
            }
            body.put("txDate", (Object)txDate);
            JSONObject reqParams = new JSONObject();
            reqParams.put("head", (Object)head);
            reqParams.put("body", (Object)body);
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_REFUND_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryRefundStatusResponse processQueryRefundStatusResponse(QueryRefundStatusResponse response, QueryRefundStatusRequest request, JSONObject resultJson) {
        LOGGER.info(">>> \u5904\u7406\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u54cd\u5e94\u7ed3\u679c > ");
        try {
            JSONObject head = resultJson.optJSONObject("head");
            String respCode = head != null ? head.optString("respCode") : resultJson.optString("code");
            String respMsg = head != null ? head.optString("respMsg") : resultJson.optString("message");
            PsbcStatus psbcStatus = PsbcStatus.fromCode(respCode);
            if (psbcStatus != null && psbcStatus.isSuccess()) {
                JSONObject body = resultJson.optJSONObject("body");
                if (body != null) {
                    PaymentStatus status;
                    String orderNo = body.optString("orderNo");
                    String outerRefundNo = body.optString("outerRefundNo");
                    String refundNo = body.optString("refundNo");
                    Integer refundAmt = body.optInt("refundAmt");
                    String refundTime = body.optString("refundTime");
                    String refundStatus = body.optString("refundStatus");
                    response.setOrderNo(orderNo);
                    response.setRefundOrderNo(outerRefundNo);
                    response.setRefundId(refundNo);
                    response.setRefundAmount(refundAmt);
                    response.setRefundDateTime(refundTime);
                    response.setTransactionId(refundTime);
                    switch (refundStatus) {
                        case "040": {
                            status = PaymentStatus.REFUND_SUCCESS;
                            response.setRefundResult("\u9000\u6b3e\u6210\u529f");
                            break;
                        }
                        case "041": {
                            status = PaymentStatus.REFUND_PROCESSING;
                            response.setRefundResult("\u9000\u6b3e\u5904\u7406\u4e2d");
                            break;
                        }
                        case "042": {
                            status = PaymentStatus.REFUND_FAIL;
                            response.setRefundResult("\u9000\u6b3e\u5931\u8d25");
                            break;
                        }
                        case "043": {
                            status = PaymentStatus.QUERY_REFUND_FAIL;
                            response.setRefundResult("\u9000\u6b3e\u72b6\u6001\u672a\u660e");
                            break;
                        }
                        default: {
                            status = PaymentStatus.QUERY_REFUND_FAIL;
                            response.setRefundResult("\u9000\u6b3e\u72b6\u6001\u672a\u77e5");
                        }
                    }
                    response.setState(status);
                    response.setCode(status.getCode());
                    response.setMessage(status.getMessage());
                    LOGGER.info("\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u6210\u529f\uff0c\u8ba2\u5355\u53f7: {}, \u9000\u6b3e\u5355\u53f7: {}, \u72b6\u6001: {}, \u91d1\u989d: {}", new Object[]{orderNo, outerRefundNo, refundStatus, refundAmt});
                } else {
                    LOGGER.warn("\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u54cd\u5e94\u6d88\u606f\u4f53\u4e3a\u7a7a");
                    response.setState(PaymentStatus.QUERY_REFUND_FAIL);
                    response.setRefundResult("\u9000\u6b3e\u72b6\u6001\u672a\u77e5");
                }
            } else {
                String errorMessage = "\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u5931\u8d25";
                if (psbcStatus != null) {
                    errorMessage = psbcStatus.getMessage();
                    LOGGER.warn("\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u5931\u8d25\uff0c\u9519\u8bef\u7801: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)psbcStatus.getCode(), (Object)psbcStatus.getMessage());
                } else {
                    LOGGER.warn("\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8bef\u7801: {}, \u54cd\u5e94\u4fe1\u606f: {}", (Object)respCode, (Object)respMsg);
                    errorMessage = respMsg != null && !respMsg.isEmpty() ? respMsg : "\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u5931\u8d25";
                }
                response.setState(PaymentStatus.QUERY_REFUND_FAIL);
                response.setRefundResult(errorMessage);
                response.setCode(PaymentStatus.QUERY_REFUND_FAIL.getCode());
                response.setMessage(errorMessage);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u54cd\u5e94\u5f02\u5e38", (Throwable)e);
            response.setState(PaymentStatus.QUERY_REFUND_FAIL);
            response.setRefundResult("\u67e5\u8be2\u5f02\u5e38");
            response.setCode(PaymentStatus.QUERY_REFUND_FAIL.getCode());
            response.setMessage("\u67e5\u8be2\u5f02\u5e38");
        }
        return response;
    }

    @Override
    protected JSONObject buildDownloadReconciliationFileRequestParams(DownloadReconciliationFileRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>>>>>>>\u5f00\u59cb\u6784\u5efa\u4e0b\u8f7d\u5bf9\u8d26\u6587\u4ef6\u8bf7\u6c42\u53c2\u6570");
        try {
            JSONObject head = this.getRequestHeard(paymentConfig);
            head.put("trancode", (Object)"reconcile");
            head.put("msgId", (Object)new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
            JSONObject body = new JSONObject();
            body.put("payItemNo", (Object)paymentConfig.getString("payItemNo"));
            body.put("extends1", (Object)"");
            body.put("extends2", (Object)"");
            body.put("extends3", (Object)"");
            body.put("extends4", (Object)"");
            body.put("txnDate", (Object)request.getTradeTime());
            JSONObject reqParams = new JSONObject();
            reqParams.put("head", (Object)head);
            reqParams.put("body", (Object)body);
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u4e0b\u8f7d\u5bf9\u8d26\u6587\u4ef6\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.BUILD_RECONCILE_FILE_DOWNLOAD_REQUEST_FAIL.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected DownloadReconciliationFileResponse processDownloadReconciliationFileResponse(DownloadReconciliationFileResponse response, DownloadReconciliationFileRequest request, JSONObject resultJson) {
        LOGGER.info(">>> \u5904\u7406\u4e0b\u8f7d\u5bf9\u8d26\u6587\u4ef6\u54cd\u5e94\u7ed3\u679c > ");
        try {
            PsbcStatus psbcStatus;
            String respMsg;
            JSONObject head = resultJson.optJSONObject("head");
            String respCode = head != null ? head.optString("respCode") : resultJson.optString("code");
            String string = respMsg = head != null ? head.optString("respMsg") : resultJson.optString("message");
            if (head != null) {
                String version = head.optString("version");
                String trancode = head.optString("trancode");
                String msgId = head.optString("msgId");
                String channelId = head.optString("channelId");
                LOGGER.info("\u4e0b\u8f7d\u5bf9\u8d26\u6587\u4ef6\u54cd\u5e94\u5934\u4fe1\u606f - \u7248\u672c\u53f7: {}, \u4ea4\u6613\u7801: {}, \u62a5\u6587ID: {}, \u6536\u8d39\u5355\u4f4d\u4ee3\u53f7: {}", new Object[]{version, trancode, msgId, channelId});
            }
            if ((psbcStatus = PsbcStatus.fromCode(respCode)) != null && psbcStatus.isSuccess()) {
                JSONObject body = resultJson.optJSONObject("body");
                if (body != null) {
                    String fileName = body.optString("fileName");
                    String fileContent = body.optString("fileContent");
                    String fileDownloadUrl = request.getDownloadPath();
                    String zipFilePath = fileDownloadUrl + "\\" + fileName + ".zip";
                    FileUtils.decodeFileContent(zipFilePath, fileContent);
                    if (!fileDownloadUrl.isEmpty()) {
                        response.setFileDownloadUrl(fileDownloadUrl);
                        response.setCode(PaymentStatus.RECONCILE_FILE_SUCCESS.getCode());
                        response.setMessage(PaymentStatus.RECONCILE_FILE_SUCCESS.getMessage());
                        LOGGER.info("\u5bf9\u8d26\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\uff0c\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740: {}\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}", (Object)fileDownloadUrl, (Object)fileName);
                    } else {
                        LOGGER.warn("\u54cd\u5e94\u6210\u529f\u4f46\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a");
                        response.setCode(PaymentStatus.RECONCILE_FILE_DOWNLOAD_URL_ERROR.getCode());
                        response.setMessage(PaymentStatus.RECONCILE_FILE_DOWNLOAD_URL_ERROR.getMessage());
                    }
                } else {
                    LOGGER.warn("\u54cd\u5e94\u6d88\u606f\u4f53\u4e3a\u7a7a");
                    response.setCode(PaymentStatus.RECONCILE_FILE_FAIL.getCode());
                    response.setMessage("\u54cd\u5e94\u6570\u636e\u5f02\u5e38");
                }
            } else {
                String errorMessage;
                if (psbcStatus != null) {
                    errorMessage = psbcStatus.getMessage();
                    LOGGER.warn("\u4e0b\u8f7d\u5bf9\u8d26\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u7801: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)psbcStatus.getCode(), (Object)psbcStatus.getMessage());
                } else {
                    LOGGER.warn("\u4e0b\u8f7d\u5bf9\u8d26\u6587\u4ef6\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8bef\u7801: {}, \u54cd\u5e94\u4fe1\u606f: {}", (Object)respCode, (Object)respMsg);
                    errorMessage = respMsg != null && !respMsg.isEmpty() ? respMsg : "\u4e0b\u8f7d\u5bf9\u8d26\u6587\u4ef6\u5931\u8d25";
                }
                response.setCode(PaymentStatus.RECONCILE_FILE_FAIL.getCode());
                response.setMessage(errorMessage);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u4e0b\u8f7d\u5bf9\u8d26\u6587\u4ef6\u54cd\u5e94\u5f02\u5e38", (Throwable)e);
            response.setCode(PaymentStatus.RECONCILE_FILE_FAIL.getCode());
            response.setMessage("\u5904\u7406\u4e0b\u8f7d\u5bf9\u8d26\u6587\u4ef6\u54cd\u5e94\u5f02\u5e38");
        }
        return response;
    }

    @Override
    protected void signRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            JSONObject signedParams = SignUtils.signRequestParamsWithSM2(reqParams, paymentConfig);
            reqParams.clear();
            for (String key : signedParams.keySet()) {
                reqParams.put(key, signedParams.get(key));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new PaymentException(PaymentStatus.SIGN_FAIL.getCode(), reqParams.toString(), PaymentStatus.SIGN_FAIL.getMessage());
        }
    }

    @Override
    protected JSONObject executePaymentRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            JSONObject jsonObject;
            String cipherInfo;
            String action;
            String urlKey = switch (action = reqParams.optString("trancode", "PAY")) {
                case "QUERY" -> "queryUrl";
                case "REFUND" -> "refundUrl";
                case "REFUND_QUERY" -> "refundQueryUrl";
                default -> "payUrl";
            };
            String url = this.buildRequestUrl(paymentConfig, urlKey);
            String requestBody = cipherInfo = reqParams.getString("cipherInfo");
            LOGGER.info("=== \u53d1\u9001\u8bf7\u6c42\u53c2\u6570\u8be6\u60c5 ===");
            LOGGER.info("\u64cd\u4f5c\u7c7b\u578b: {}", (Object)action);
            LOGGER.info("\u8bf7\u6c42URL: {}", (Object)url);
            LOGGER.info("\u53d1\u9001\u7ed9\u7f51\u5173\u7684\u53c2\u6570: {}", (Object)reqParams);
            LOGGER.info("\u53d1\u9001\u7ed9\u7f51\u5173\u7684JSON\u5b57\u7b26\u4e32: {}", (Object)requestBody);
            String response = this.sendPostLikeOfficial(url, requestBody);
            try {
                jsonObject = new JSONObject(response);
            }
            catch (Exception first) {
                if (response.contains("|+|")) {
                    try {
                        jsonObject = SignUtils.parsePsbcPlainResponse(response, paymentConfig);
                    }
                    catch (Exception second) {
                        LOGGER.error("PSBC\u660e\u6587\u54cd\u5e94\u89e3\u6790\u5931\u8d25: {}", (Object)second.getMessage(), (Object)second);
                        throw second;
                    }
                }
                if (response.contains("invalid IPv6 address")) {
                    LOGGER.error("\u90ae\u50a8\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u54cd\u5e94: {}", (Object)response);
                    jsonObject = new JSONObject();
                    jsonObject.put("code", (Object)"9999");
                    jsonObject.put("message", (Object)("\u90ae\u50a8\u94f6\u884c\u7f51\u5173\u9519\u8bef: " + response));
                    jsonObject.put("error", (Object)response);
                }
                LOGGER.warn("\u54cd\u5e94\u4e0d\u662fJSON\u683c\u5f0f\uff0c\u5c1d\u8bd5XML\u8f6cJSON: {}", (Object)first.getMessage());
                jsonObject = JsonTools.xmlConvertToJson((String)response);
            }
            LOGGER.info(">>> [{}] \u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)action, (Object)jsonObject);
            return jsonObject;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u652f\u4ed8\u4e1a\u52a1\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), reqParams.toString(), PaymentStatus.PAY_ORDER_ERROR.getMessage());
        }
    }

    private String buildRequestUrl(JSONObject paymentConfig, String urlKey) {
        String channelId = paymentConfig.getString("channelId");
        String base = paymentConfig.optString("transactionurl", "");
        if (base == null) {
            base = "";
        }
        if (base.endsWith("/")) {
            return base + "payment/" + channelId;
        }
        return base + "/payment/" + channelId;
    }

    @Override
    protected boolean verifyResponseSign(JSONObject response, JSONObject paymentConfig) {
        try {
            return SignUtils.verifySignWithSM2(response, paymentConfig);
        }
        catch (Exception e) {
            LOGGER.error("\u9a8c\u7b7e\u5931\u8d25\uff01", (Throwable)e);
            throw new PaymentException(PaymentStatus.VERIFY_SIGN_FAIL.getCode(), "{}", PaymentStatus.VERIFY_SIGN_FAIL.getMessage());
        }
    }

    private JSONObject getRequestHeard(JSONObject paymentConfig) {
        JSONObject reqParams = new JSONObject();
        reqParams.put("channelId", (Object)paymentConfig.getString("channelId"));
        reqParams.put("version", (Object)"1.0.0");
        return reqParams;
    }

    private String sendPostLikeOfficial(String uri, String param) {
        try {
            return HttpConnectionPoolUtil.request((String)param, null, null, (Boolean)false, (HttpUriRequestBase)new HttpPost(uri));
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001HTTP\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            throw new PaymentException("\u53d1\u9001HTTP\u8bf7\u6c42\u5931\u8d25", e.getMessage());
        }
    }
}

