package com.af.v4.system.common.payment.dto;

import org.json.JSONObject;

/**
 * 查询订单状态请求参数
 */
public class QueryPaymentStatusRequest {
    /**
     * 商户订单号（业务系统生成的唯一订单号）
     */
    private final String orderNo;
    private final String transactionId;
    /**
     * 银行名称
     */
    private final String bankName;
    /**
     * 分公司名称
     */
    private final String orgName;

    /**
     * 自定义扩充参数
     */
    private final JSONObject customParams;

    // 私有构造函数，防止直接实例化
    private QueryPaymentStatusRequest(Builder builder) {
        this.orderNo = builder.orderNo;
        this.bankName = builder.bankName;
        this.orgName = builder.orgName;
        this.transactionId = builder.transactionId;
        this.customParams = builder.customParams;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public String getBankName() {
        return bankName;
    }

    public String getOrgName() {
        return orgName;
    }
    public String getTransactionId() {
        return transactionId;
    }

    public JSONObject getCustomParams() {
        return customParams;
    }

    // Builder 静态内部类
    public static class Builder {
        private String orderNo;
        private String bankName;
        private String orgName;
        private String transactionId;
        private JSONObject customParams;

        public Builder() {
        }

        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("orderNo")) {
                builder.orderNo(jsonObject.getString("orderNo"));
            }
            if (jsonObject.has("bankName")) {
                builder.bankName(jsonObject.getString("bankName"));
            }
            if (jsonObject.has("orgName")) {
                builder.orgName(jsonObject.getString("orgName"));
            }
            if (jsonObject.has("transactionId")) {
                builder.transactionId(jsonObject.getString("transactionId"));
            }
            builder.customParams(jsonObject.optJSONObject("customParams", new JSONObject()));
            return builder;

        }

        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }


        public Builder orgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public Builder bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }
        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder customParams(JSONObject customParams) {
            this.customParams = customParams;
            return this;
        }
        public QueryPaymentStatusRequest build() {
            return new QueryPaymentStatusRequest(this);
        }
    }
}