/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.utils;

import com.af.v4.system.common.payment.utils.RSAUtils;
import java.io.StringReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class SignUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignUtils.class);
    private static final String SIGN_TYPE_RSA = "RSA_1_256";
    private static final String SIGN_KEY = "sign";

    public static void signRequestParams(JSONObject reqParams, String signType, String key) throws Exception {
        try {
            Map<String, String> filteredParams = SignUtils.filterAndSortParams(reqParams.toMap());
            String preStr = SignUtils.buildPreSignString(filteredParams);
            signType = Optional.ofNullable(signType).orElse(SIGN_TYPE_RSA);
            String sign = SignUtils.generateSign(signType, preStr, key);
            reqParams.put(SIGN_KEY, (Object)sign);
            LOGGER.info("\u7b7e\u540d\u751f\u6210\u6210\u529f: signType={}, sign={}", (Object)signType, (Object)sign);
            LOGGER.info("\u52a0\u7b7e\u540e\u7684\u8bf7\u6c42\u53c2\u6570: reqParams={}", (Object)reqParams);
        }
        catch (Exception e) {
            LOGGER.error("\u7b7e\u540d\u751f\u6210\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new Exception("\u7b7e\u540d\u751f\u6210\u5931\u8d25", e);
        }
    }

    public static void signRequestParams(JSONObject reqParams, String key) throws Exception {
        SignUtils.signRequestParams(reqParams, null, key);
    }

    private static String generateSign(String signType, String preStr, String key) {
        if (SIGN_TYPE_RSA.equalsIgnoreCase(signType)) {
            try {
                byte[] signature = RSAUtils.sign(RSAUtils.SignatureSuite.SHA256, preStr.getBytes(StandardCharsets.UTF_8), key);
                return Base64.getEncoder().encodeToString(signature);
            }
            catch (Exception e) {
                throw new RuntimeException("\u7b7e\u540d\u751f\u6210\u5931\u8d25: " + e.getMessage(), e);
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u65b9\u5f0f: " + signType);
    }

    public static boolean verifySign(JSONObject result, String signType, String platKey) throws Exception {
        Map resultMap = result.toMap();
        String sign = resultMap.get(SIGN_KEY).toString();
        if (sign == null) {
            LOGGER.error("\u7f3a\u5c11\u7b7e\u540d\u5b57\u6bb5");
            return false;
        }
        Map<String, String> filteredParams = SignUtils.filterAndSortParams(resultMap);
        String preStr = SignUtils.buildPreSignString(filteredParams);
        if (SIGN_TYPE_RSA.equals(signType)) {
            return RSAUtils.verifySign(RSAUtils.SignatureSuite.SHA256, preStr.getBytes(StandardCharsets.UTF_8), Base64.getDecoder().decode(sign), platKey);
        }
        LOGGER.error("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u65b9\u5f0f: {}", (Object)signType);
        return false;
    }

    private static Map<String, String> filterAndSortParams(Map<String, Object> reqParams) {
        return reqParams.entrySet().stream().filter(entry -> entry.getValue() != null && !SIGN_KEY.equalsIgnoreCase((String)entry.getKey())).sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(entry.getValue()), (oldValue, newValue) -> oldValue, LinkedHashMap::new));
    }

    private static String buildPreSignString(Map<String, String> params) {
        return params.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + SignUtils.urlEncode((String)entry.getValue())).collect(Collectors.joining("&"));
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            LOGGER.warn("URL \u7f16\u7801\u5931\u8d25: {}", (Object)value, (Object)e);
            return value;
        }
    }

    private void validateParams(JSONObject reqParams) {
        if (reqParams == null || reqParams.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public Element parseXml(String xml, String encode) throws DocumentException {
        SAXReader reader = new SAXReader(false);
        InputSource source = new InputSource(new StringReader(xml));
        source.setEncoding(encode);
        Document doc = reader.read(source);
        return doc.getRootElement();
    }
}

