/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.utils;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class RSAUtils {
    private static KeyFactory getKeyFactory() {
        try {
            return KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("\u521d\u59cb\u5316 RSA KeyFactory \u5931\u8d25", e);
        }
    }

    public static byte[] sign(SignatureSuite suite, byte[] message, String privateKeyStr) {
        try {
            Signature signature = Signature.getInstance(suite.getValue());
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKeyStr));
            PrivateKey privateKey = RSAUtils.getKeyFactory().generatePrivate(keySpec);
            signature.initSign(privateKey);
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u751f\u6210\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static boolean verifySign(SignatureSuite suite, byte[] message, byte[] signatureBytes, String publicKeyStr) {
        try {
            Signature signature = Signature.getInstance(suite.getValue());
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyStr));
            PublicKey publicKey = RSAUtils.getKeyFactory().generatePublic(keySpec);
            signature.initVerify(publicKey);
            signature.update(message);
            return signature.verify(signatureBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static enum SignatureSuite {
        SHA1("SHA1WithRSA"),
        SHA256("SHA256WithRSA");

        private final String suite;

        private SignatureSuite(String suite) {
            this.suite = suite;
        }

        public String getValue() {
            return this.suite;
        }
    }
}

