/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.service;

import com.af.v4.system.common.payment.config.PaymentConfig;
import com.af.v4.system.common.payment.dto.CancelPaymentRequest;
import com.af.v4.system.common.payment.dto.CancelPaymentResponse;
import com.af.v4.system.common.payment.dto.PayOrderRequest;
import com.af.v4.system.common.payment.dto.PayOrderResponse;
import com.af.v4.system.common.payment.dto.PaymentQueryStatusRequest;
import com.af.v4.system.common.payment.dto.PaymentQueryStatusResponse;
import com.af.v4.system.common.payment.dto.QueryRefundStatusRequest;
import com.af.v4.system.common.payment.dto.QueryRefundStatusResponse;
import com.af.v4.system.common.payment.dto.RefundPaymentRequest;
import com.af.v4.system.common.payment.dto.RefundPaymentResponse;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.factory.PaymentHandlerFactory;
import com.af.v4.system.common.payment.handler.PaymentHandler;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaymentService.class);
    private static final int TIMEOUT_SECONDS = 5;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final JSONObject paymentConfig;
    private final IntegrationType integrationType;
    private final BankName bankName;

    private PaymentService(PaymentConfig paymentConfig) {
        this.paymentConfig = paymentConfig.paymentConfig;
        this.integrationType = paymentConfig.integrationType;
        this.bankName = paymentConfig.bankName;
    }

    public PayOrderResponse processPayment(PayOrderRequest request) {
        try {
            PaymentHandler handler = this.getPaymentHandler(this.bankName, this.integrationType);
            Future<PayOrderResponse> future = this.executorService.submit(() -> handler.paymentOrder(request, this.paymentConfig));
            return future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new PaymentException(PaymentStatus.CONNECT_TIME_OUT.getCode(), request.toString(), PaymentStatus.CONNECT_TIME_OUT.getMessage());
        }
        catch (Exception e) {
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), request.toString(), e.getMessage());
        }
    }

    public PaymentQueryStatusResponse queryPaymentStatus(PaymentQueryStatusRequest request) {
        try {
            PaymentHandler handler = this.getPaymentHandler(this.bankName, this.integrationType);
            Future<PaymentQueryStatusResponse> future = this.executorService.submit(() -> handler.queryPaymentStatus(request, this.paymentConfig));
            return future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new PaymentException(PaymentStatus.CONNECT_TIME_OUT.getCode(), request.toString(), PaymentStatus.CONNECT_TIME_OUT.getMessage());
        }
        catch (Exception e) {
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), request.toString(), e.getMessage());
        }
    }

    public CancelPaymentResponse cancelPayment(CancelPaymentRequest request) {
        try {
            PaymentHandler handler = this.getPaymentHandler(this.bankName, this.integrationType);
            Future<CancelPaymentResponse> future = this.executorService.submit(() -> handler.cancelOrder(request, this.paymentConfig));
            return future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new PaymentException(PaymentStatus.CONNECT_TIME_OUT.getCode(), request.toString(), PaymentStatus.CONNECT_TIME_OUT.getMessage());
        }
        catch (Exception e) {
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), request.toString(), e.getMessage());
        }
    }

    public RefundPaymentResponse refundPayment(RefundPaymentRequest request) {
        try {
            PaymentHandler handler = this.getPaymentHandler(this.bankName, this.integrationType);
            Future<RefundPaymentResponse> future = this.executorService.submit(() -> handler.refundPayment(request, this.paymentConfig));
            return future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new PaymentException(PaymentStatus.CONNECT_TIME_OUT.getCode(), request.toString(), PaymentStatus.CONNECT_TIME_OUT.getMessage());
        }
        catch (Exception e) {
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), request.toString(), e.getMessage());
        }
    }

    public QueryRefundStatusResponse queryRefundStatus(QueryRefundStatusRequest request) {
        try {
            PaymentHandler handler = this.getPaymentHandler(this.bankName, this.integrationType);
            Future<QueryRefundStatusResponse> future = this.executorService.submit(() -> handler.queryRefundStatus(request, this.paymentConfig));
            return future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new PaymentException(PaymentStatus.CONNECT_TIME_OUT.getCode(), request.toString(), PaymentStatus.CONNECT_TIME_OUT.getMessage());
        }
        catch (Exception e) {
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), request.toString(), e.getMessage());
        }
    }

    private PaymentHandler getPaymentHandler(BankName bankName, IntegrationType integrationType) {
        try {
            return PaymentHandlerFactory.getHandler(bankName, integrationType);
        }
        catch (PaymentException e) {
            throw new PaymentException(PaymentStatus.INVALID_CONNECTION_METHOD_OR_BANK_NAME.getCode(), "{}", PaymentStatus.INVALID_CONNECTION_METHOD_OR_BANK_NAME.getMessage());
        }
    }

    public String generateOrderNumber() {
        return "ORD-" + UUID.randomUUID().toString().replaceAll("-", "").substring(0, 16).toUpperCase();
    }
}

