/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.factory;

import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.handler.PaymentHandler;
import java.util.HashMap;
import java.util.Map;

public class PaymentHandlerFactory {
    private static final Map<String, PaymentHandler> HANDLER_MAP = new HashMap<String, PaymentHandler>();

    public static void registerHandler(BankName bankName, IntegrationType integrationType, PaymentHandler handler) {
        String key = PaymentHandlerFactory.generateKey(bankName, integrationType);
        HANDLER_MAP.put(key, handler);
    }

    public static PaymentHandler getHandler(BankName bankName, IntegrationType integrationType) {
        String key = PaymentHandlerFactory.generateKey(bankName, integrationType);
        PaymentHandler handler = HANDLER_MAP.get(key);
        if (handler == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5904\u7406\u5668: \u94f6\u884c\u540d\u79f0=" + String.valueOf((Object)bankName) + ", \u5bf9\u63a5\u65b9\u5f0f=" + String.valueOf((Object)integrationType));
        }
        return handler;
    }

    private static String generateKey(BankName bankName, IntegrationType integrationType) {
        return String.valueOf((Object)bankName) + "-" + integrationType.name();
    }
}

