/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.dto;

import org.json.JSONObject;

public class PayOrderRequest {
    private String orderNo;
    private int amount;
    private String authCode;
    private String paymentConfigName;
    private String description;
    private String notifyUrl;
    private String userInfoCode;
    private String customParam;

    private PayOrderRequest(Builder builder) {
        this.orderNo = builder.orderNo;
        this.amount = builder.amount;
        this.authCode = builder.authCode;
        this.paymentConfigName = builder.paymentConfigName;
        this.description = builder.description;
        this.notifyUrl = builder.notifyUrl;
        this.userInfoCode = builder.userInfoCode;
        this.customParam = builder.customParam;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getPaymentConfigName() {
        return this.paymentConfigName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getUserInfoCode() {
        return this.userInfoCode;
    }

    public String getCustomParam() {
        return this.customParam;
    }

    public static class Builder {
        private String orderNo;
        private int amount;
        private String authCode;
        private String paymentConfigName;
        private String description;
        private String notifyUrl;
        private String userInfoCode;
        private String customParam;

        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("orderNo")) {
                builder.orderNo(jsonObject.getString("orderNo"));
            }
            if (jsonObject.has("amount")) {
                builder.amount(jsonObject.getInt("amount"));
            }
            if (jsonObject.has("authCode")) {
                builder.authCode(jsonObject.getString("authCode"));
            }
            if (jsonObject.has("paymentConfigName")) {
                builder.paymentConfigName(jsonObject.getString("paymentConfigName"));
            }
            if (jsonObject.has("description")) {
                builder.description(jsonObject.getString("description"));
            }
            if (jsonObject.has("notifyUrl")) {
                builder.notifyUrl(jsonObject.getString("notifyUrl"));
            }
            if (jsonObject.has("userInfoCode")) {
                builder.userInfoCode(jsonObject.getString("userInfoCode"));
            }
            if (jsonObject.has("customParam")) {
                builder.customParam(jsonObject.getString("customParam"));
            }
            return builder;
        }

        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        public Builder paymentConfigName(String paymentConfigName) {
            this.paymentConfigName = paymentConfigName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public Builder userInfoCode(String userInfoCode) {
            this.userInfoCode = userInfoCode;
            return this;
        }

        public Builder customParam(String customParam) {
            this.customParam = customParam;
            return this;
        }

        public PayOrderRequest build() {
            return new PayOrderRequest(this);
        }
    }
}

