/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.utils;

import com.af.v4.system.common.payment.utils.RSAUtils;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignUtils.class);
    private static final String SIGN_TYPE_RSA = "RSA_1_256";

    public static void signRequestParams(JSONObject reqParams, String signType, String signKey, String privateKey) throws Exception {
        try {
            Map<String, String> filteredParams = SignUtils.filterParams(reqParams.toMap());
            String preStr = SignUtils.buildSignString(filteredParams);
            LOGGER.info("\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32: {}", (Object)preStr);
            signType = Optional.ofNullable(signType).orElse(SIGN_TYPE_RSA);
            String sign = SignUtils.generateSign(signType, preStr, privateKey);
            reqParams.put(signKey, (Object)sign);
            LOGGER.info("\u7b7e\u540d\u751f\u6210\u6210\u529f: signType={}, sign={}", (Object)signType, (Object)sign);
            LOGGER.info("\u52a0\u7b7e\u540e\u7684\u8bf7\u6c42\u53c2\u6570: reqParams={}", (Object)reqParams);
        }
        catch (Exception e) {
            LOGGER.error("\u7b7e\u540d\u751f\u6210\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new Exception("\u7b7e\u540d\u751f\u6210\u5931\u8d25", e);
        }
    }

    public static void signRequestParams(JSONObject reqParams, String privateKey) throws Exception {
        SignUtils.signRequestParams(reqParams, SIGN_TYPE_RSA, "sign", privateKey);
    }

    private static String generateSign(String signType, String preStr, String privateKey) {
        if (SIGN_TYPE_RSA.equalsIgnoreCase(signType)) {
            try {
                byte[] signature = RSAUtils.sign(RSAUtils.SignatureSuite.SHA256, preStr.getBytes(StandardCharsets.UTF_8), privateKey);
                return new String(Base64.encodeBase64((byte[])signature), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new RuntimeException("\u7b7e\u540d\u751f\u6210\u5931\u8d25: " + e.getMessage(), e);
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u65b9\u5f0f: " + signType);
    }

    public static boolean verifySign(JSONObject response, String signType, String sign, String publicKey) {
        if (SIGN_TYPE_RSA.equals(signType)) {
            Map<String, String> Reparams = SignUtils.filterParams(response.toMap());
            String repreStr = SignUtils.buildSignString(Reparams);
            LOGGER.info("\u5f85\u9a8c\u7b7e\u5b57\u7b26\u4e32: {}", (Object)repreStr);
            return RSAUtils.verifySign(RSAUtils.SignatureSuite.SHA256, repreStr, sign, publicKey);
        }
        return false;
    }

    public static Map<String, String> filterParams(Map<String, Object> params) {
        return params.entrySet().stream().filter(entry -> !"sign".equals(entry.getKey()) && entry.getValue() != null && !entry.getValue().toString().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
    }

    public static String buildSignString(Map<String, String> params) {
        return params.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
    }
}

