/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.utils;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class RSAUtils {
    private static KeyFactory getKeyFactory() {
        try {
            return KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("\u521d\u59cb\u5316 RSA KeyFactory \u5931\u8d25", e);
        }
    }

    public static byte[] sign(SignatureSuite suite, byte[] message, String privateKeyStr) {
        try {
            Signature signature = Signature.getInstance(suite.getValue());
            byte[] keyBytes = Base64.decodeBase64((String)privateKeyStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            PrivateKey privateKey = RSAUtils.getKeyFactory().generatePrivate(keySpec);
            signature.initSign(privateKey);
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u751f\u6210\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static boolean verifySign(SignatureSuite suite, String message, String signatureBase64, String publicKeyStr) {
        try {
            Signature signature = Signature.getInstance(suite.getValue());
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKeyStr));
            PublicKey publicKey = RSAUtils.getKeyFactory().generatePublic(keySpec);
            signature.initVerify(publicKey);
            signature.update(message.getBytes(StandardCharsets.UTF_8));
            return signature.verify(Base64.decodeBase64((String)signatureBase64));
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static enum SignatureSuite {
        SHA1("SHA1WithRSA"),
        SHA256("SHA256WithRSA");

        private final String suite;

        private SignatureSuite(String suite) {
            this.suite = suite;
        }

        public String getValue() {
            return this.suite;
        }
    }
}

