/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.utils;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.plugins.date.DateTools;
import java.lang.reflect.Field;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentUtils {
    private static final Random SECURE_RANDOM = new SecureRandom();
    private static final Logger LOGGER = LoggerFactory.getLogger(PaymentUtils.class);

    public static String generateSerialNumber() {
        String timestamp = DateTools.getNow((String)"yyyyMMddHHmmss");
        int randomNum = SECURE_RANDOM.nextInt(900000) + 100000;
        return timestamp + randomNum;
    }

    public static String generateOrderId() {
        try {
            return UUID.randomUUID().toString().replace("-", "").toUpperCase();
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210\u8ba2\u5355\u53f7\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException("\u751f\u6210\u8ba2\u5355\u53f7\u5931\u8d25", e);
        }
    }

    public static JSONObject toJson(Object obj) {
        JSONObject json = new JSONObject();
        if (obj == null) {
            return json;
        }
        try {
            Field[] fields;
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value == null) continue;
                json.put(field.getName(), value);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u5bf9\u8c61\u8f6c\u6362\u4e3a JSON \u5931\u8d25", Integer.valueOf(500));
        }
        return json;
    }
}

