/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.factory;

import com.af.v4.system.common.payment.annotation.PaymentHandlerConfig;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.handler.PaymentHandler;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class PaymentHandlerFactory {
    private static final Map<String, PaymentHandler> HANDLER_MAP = new ConcurrentHashMap<String, PaymentHandler>();
    private final ApplicationContext applicationContext;
    Logger LOGGER = LoggerFactory.getLogger(PaymentHandlerFactory.class);

    public PaymentHandlerFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public static PaymentHandler getHandler(BankName bankName, IntegrationType integrationType) {
        String key = PaymentHandlerFactory.generateKey(bankName, integrationType);
        PaymentHandler handler = HANDLER_MAP.get(key);
        if (handler == null) {
            throw new PaymentException(PaymentStatus.INVALID_CONNECTION_METHOD_OR_BANK_NAME.getMessage(), "{}", PaymentStatus.INVALID_CONNECTION_METHOD_OR_BANK_NAME.getMessage());
        }
        return handler;
    }

    private static String generateKey(BankName bankName, IntegrationType integrationType) {
        return String.valueOf((Object)bankName) + "-" + integrationType.name();
    }

    @PostConstruct
    private void registerHandlers() {
        Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(PaymentHandlerConfig.class);
        for (Map.Entry entry : beansWithAnnotation.entrySet()) {
            PaymentHandler handler = (PaymentHandler)entry.getValue();
            PaymentHandlerConfig config = handler.getClass().getAnnotation(PaymentHandlerConfig.class);
            String key = PaymentHandlerFactory.generateKey(config.bankName(), config.integrationType());
            if (HANDLER_MAP.containsKey(key)) {
                throw new IllegalStateException("\u652f\u4ed8\u4e1a\u52a1\u5904\u7406\u5668\u91cd\u590d\u6ce8\u518c: " + key);
            }
            this.LOGGER.info("\u6ce8\u518c\u652f\u4ed8\u4e1a\u52a1\u5904\u7406\u5668[key: {}\uff0chandler: {}]", (Object)key, (Object)handler);
            HANDLER_MAP.put(key, handler);
        }
        this.LOGGER.info("\u6240\u6709\u652f\u4ed8\u4e1a\u52a1\u5904\u7406\u5668\u6ce8\u518c\u5b8c\u6210\uff1a\u5171{}\u4e2a", (Object)HANDLER_MAP.size());
    }
}

