package com.af.v4.system.common.payment.utils;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.plugins.date.DateTools;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

/**
 * @author llzh
 * @ClassName PaymentUtils
 * @Description 支付工具类
 * @DateTime 2024/12/24 16:59
 */
public class PaymentUtils {
    private static final Random SECURE_RANDOM = new SecureRandom();
    private static final Logger LOGGER = LoggerFactory.getLogger(PaymentUtils.class);

    /**
     * 生成唯一流水号
     * 格式：YYYYMMDDHHMMSS + 随机6位数字
     */
    public static String generateSerialNumber() {
        // 获取当前时间并格式化
        String timestamp = DateTools.getNow("yyyyMMddHHmmss");

        // 生成6位随机数字
        // 保证6位随机数
        int randomNum = SECURE_RANDOM.nextInt(900000) + 100000;

        return timestamp + randomNum;
    }

    /**
     * 生成唯一订单号
     * 格式：UUID 去除横线
     */
    public static String generateOrderId() {
        try {
            return UUID.randomUUID().toString().replace("-", "").toUpperCase();
        } catch (Exception e) {
            // 记录异常日志
            LOGGER.error("生成订单号时发生异常：{}", e.getMessage());
            throw new RuntimeException("生成订单号失败", e);
        }
    }
    /**
     * 将对象转换为 JSONObject，自动忽略值为 null 的字段
     *
     * @param obj 要转换的对象
     * @return 转换后的 JSONObject
     */
    public static JSONObject toJson(Object obj) {
        JSONObject json = new JSONObject();
        if (obj == null) {
            return json;
        }
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            for (Field field : fields) {
                // 允许访问私有字段
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value != null) {
                    json.put(field.getName(), value);
                }
            }
        } catch (Exception e) {
            throw new ServiceException("对象转换为 JSON 失败", 500);
        }
        return json;
    }
}