package com.af.v4.system.common.payment.exceptions;

import com.af.v4.system.common.core.exception.ServiceException;

/**
 * @author llzh
 * @ClassName PaymentException
 * @Description 支付相关的自定义异常
 * @DateTime 2024/12/24 17:23
 */
public class PaymentException extends ServiceException {
    // 请求的 JSON 数据
    private final String requestJson;
    // 响应的 JSON 数据
    private final String responseJson;

    public PaymentException(String message, String requestJson, String responseJson) {
        super(message);
        this.requestJson = requestJson;
        this.responseJson = responseJson;
    }

    public String getRequestJson() {
        return requestJson;
    }

    public String getResponseJson() {
        return responseJson;
    }
}