package com.af.v4.system.common.payment.enums;

/**
 * @author llzh
 * @ClassName BankNameEnums
 * @Description 银行名称
 * @DateTime 2024/12/23 15:20
 */
public enum BankName {

    BOC("中国银行"),
    CCB("中国建设银行"),
    ABC("中国农业银行"),
    ICBC("中国工商银行"),
    BCM("中国交通银行"),
    PSBC("中国邮储银行"),
    /**
     * @see <a href="https://open.swiftpass.cn/openapi/wiki?index=9&chapter=1">光大银行（C扫B 扫码设备）</a>
     */
    CEB("中国光大银行"),
    CMB("招商银行");
    private final String bankName;

    BankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankName() {
        return bankName;
    }
    public static BankName findByName(String bankName) {
        for (BankName bank : BankName.values()) {
            if (bank.getBankName().equals(bankName)) {
                return bank;
            }
        }
        throw new IllegalArgumentException("未找到对应的银行名称: " + bankName);
    }
}