package com.af.v4.system.common.payment.dto;

import com.af.v4.system.common.payment.utils.PaymentUtils;
import org.json.JSONObject;

/**
 * @author llzh
 * @ClassName RefundPaymentResponse
 * @Description 申请退款返回参数
 * @DateTime 2024/12/25 13:45
 */
public class RefundPaymentResponse {
    /**
     * 返回码
     */
    private String code;
    /**
     * 返回描述
     */
    private String message;
    /**
     * 退款结果
     */
    private String refundResult;
    /**
     * 商户号
     */
    private String mchId;
    /**
     * 商户订单号（业务系统生成的唯一订单号）
     */
    private String orderNo;
    /**
     * 第三方订单号
     */
    private String transactionId;
    /**
     * 退款订单号（业务系统生成的唯一退款订单号）
     */
    private String refundOrderNo;
    /**
     * 平台退款单号
     */
    private String refundId;
    /**
     * 退款金额（单位：分）(要和订单金额保持一致)
     * （PS:虽然支持部分退款，但不建议）
     */
    private int refundAmount;
    private JSONObject requestJson;
    public JSONObject buildJson(){
        return  PaymentUtils.toJson(this);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRefundResult() {
        return refundResult;
    }

    public void setRefundResult(String refundResult) {
        this.refundResult = refundResult;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

    public String getRefundId() {
        return refundId;
    }

    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    public int getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(int refundAmount) {
        this.refundAmount = refundAmount;
    }

    public JSONObject getRequestJson() {
        return requestJson;
    }

    public void setRequestJson(JSONObject requestJson) {
        this.requestJson = requestJson;
    }
}