package com.af.v4.system.common.payment.dto;

import org.json.JSONObject;

/**
 * 查询退款状态请求参数
 *
 * @author llzh
 * @DateTime 2024/12/30 14:06
 */
public class QueryRefundStatusRequest {
    /**
     * 商户订单号
     */
    private String orderNo;
    /**
     * 平台退款单号
     */
    private String refundId;


    // 私有构造函数，防止直接实例化
    private QueryRefundStatusRequest(Builder builder) {
        this.orderNo = builder.orderNo;
        this.refundId = builder.refundId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public String getRefundId() {
        return refundId;
    }

    // Builder 静态内部类
    public static class Builder {
        private String orderNo;
        private String refundId;

        public Builder() {
        }

        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("orderNo")) {
                builder.orderNo(jsonObject.getString("orderNo"));
            }
            if (jsonObject.has("refundId")) {
                builder.refundId(jsonObject.getString("refundId"));
            }
            return builder;

        }

        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }
        public Builder refundId(String refundId) {
            this.refundId = refundId;
            return this;
        }

        public  QueryRefundStatusRequest build() {
            return new QueryRefundStatusRequest(this);
        }
    }
}