package com.af.v4.system.common.payment.dto;


import org.json.JSONObject;

/**
 * @author llzh
 * @ClassName PaymentRequest
 * @Description 订单请求参数
 * @DateTime 2024/12/23 11:27
 */
public class PaymentOrderRequest {
    /**
     * 商户订单号（业务系统生成的唯一订单号）
     */
    private String orderNo;
    /**
     * 支付金额（单位：分）
     */
    private int amount;
    /**
     * 授权码 扫码支付授权码， 设备读取用户展示的条码或者二维码信息
     */
    private String authCode;
    /**
     * 配置名称
     */
    private String paymentConfigName;
    /**
     * 订单描述
     */
    private String description;
    /**
     * 通知回调地址（支付完成后，支付渠道会回调此地址通知支付结果）
     */
    private String notifyUrl;
    /**
     * 用户编号
     */
    private String userInfoCode;
    /**
     * 自定义参数（可选，用于支付完成后原样返回）
     */
    private String customParam;



    // 私有构造函数，防止直接实例化
    private PaymentOrderRequest(Builder builder) {
        this.orderNo = builder.orderNo;
        this.amount = builder.amount;
        this.authCode = builder.authCode;
        this.paymentConfigName = builder.paymentConfigName;
        this.description = builder.description;
        this.notifyUrl = builder.notifyUrl;
        this.userInfoCode = builder.userInfoCode;
        this.customParam = builder.customParam;
    }
    // Getters
    public String getOrderNo() {
        return orderNo;
    }

    public int getAmount() {
        return amount;
    }

    public String getAuthCode() {
        return authCode;
    }

    public String getPaymentConfigName() {
        return paymentConfigName;
    }

    public String getDescription() {
        return description;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public String getUserInfoCode() {
        return userInfoCode;
    }

    public String getCustomParam() {
        return customParam;
    }


    // Builder 静态内部类
    public static class Builder {
        private String orderNo;
        private int amount;
        private String authCode;
        private String paymentConfigName;
        private String description;
        private String notifyUrl;
        private String userInfoCode;
        private String customParam;

        public Builder() {
        }

        /**
         * 静态工厂方法，通过 JSONObject 构造 PaymentOrderRequest
         *
         * @param jsonObject 参数
         * @return 构造器
         */
        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("orderNo")) {
                builder.orderNo(jsonObject.getString("orderNo"));
            }
            if (jsonObject.has("amount")) {
                builder.amount(jsonObject.getInt("amount"));
            }
            if (jsonObject.has("authCode")) {
                builder.authCode(jsonObject.getString("authCode"));
            }
            if (jsonObject.has("paymentConfigName")) {
                builder.paymentConfigName(jsonObject.getString("paymentConfigName"));
            }
            if (jsonObject.has("description")) {
                builder.description(jsonObject.getString("description"));
            }
            if (jsonObject.has("notifyUrl")) {
                builder.notifyUrl(jsonObject.getString("notifyUrl"));
            }
            if (jsonObject.has("userInfoCode")) {
                builder.userInfoCode(jsonObject.getString("userInfoCode"));
            }
            if (jsonObject.has("customParam")) {
                builder.customParam(jsonObject.getString("customParam"));
            }
            return builder;
        }


        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        public Builder paymentConfigName(String paymentConfigName) {
            this.paymentConfigName = paymentConfigName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public Builder userInfoCode(String userInfoCode) {
            this.userInfoCode = userInfoCode;
            return this;
        }

        public Builder customParam(String customParam) {
            this.customParam = customParam;
            return this;
        }



        public PaymentOrderRequest build() {
            return new PaymentOrderRequest(this);
        }
    }
}