package com.af.v4.system.common.payment.dto;

import org.json.JSONObject;

/**
 * @author llzh
 * @ClassName CancelPaymentRequest
 * @Description 撤销订单请求参数
 * @DateTime 2024/12/25 13:39
 */
public class CancelPaymentRequest {
    /**
     * 商户订单号（业务系统生成的唯一订单号）
     */
    private String orderNo;


    // 私有构造函数，防止直接实例化
    private CancelPaymentRequest(Builder builder) {
        this.orderNo = builder.orderNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    // Builder 静态内部类
    public static class Builder {
        private String orderNo;

        public Builder() {
        }

        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("orderNo")) {
                builder.orderNo(jsonObject.getString("orderNo"));
            }
            return builder;

        }

        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public  CancelPaymentRequest build() {
            return new CancelPaymentRequest(this);
        }
    }
}