package com.af.v4.system.common.payment.config;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import org.checkerframework.checker.units.qual.C;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

/**
  *  支付配置
  *
  * @author  llzh
  * @DateTime 2024/12/25 17:49
  */
@Component
public class PaymentConfig {
    public LiuLiConfigService liuLiConfigService;
    public JSONObject paymentConfig;
    public IntegrationType integrationType;
    public BankName bankName;

    public PaymentConfig(LiuLiConfigService liuLiConfigService) {
        this.liuLiConfigService = liuLiConfigService;
        this.paymentConfig = liuLiConfigService.get("PaymentConfig",true);
        this.bankName = BankName.findByName(paymentConfig.getString("bankName"));
        this.integrationType = IntegrationType.findByDescription(paymentConfig.getString("integrationType"));
    }
}