package com.af.v4.system.common.payment.dto;


import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.utils.PaymentUtils;
import org.json.JSONObject;

/**
 * @author llzh
 * @ClassName PaymentRequest
 * @Description 订单返回参数
 * @DateTime 2024/12/23 11:27
 */
public class PaymentOrderResponse {
    /**
     * 返回码
     */
    private String code;
    /**
     * 返回描述
     */
    private String message;
    /**
     * 商户号
     */
    private String mchId;
    /**
     * 商户订单号（业务系统生成的唯一订单号）
     */
    private String orderNo;
    /**
     * 第三方订单号
     */
    private String transactionId;
    /**
     * 支付金额（单位：分）
     */
    private int amount;
    /**
     * 请求报文
     */
    private JSONObject requestJson;
    /**
     * 自定义参数（可选，用于支付完成后原样返回）
     */
    private String customParam;
    // 扫码设备字段
    /**
     * 是否需要主动查询
     */
    private Boolean needQuery;
    /**
     * 支付结果
     */
    private String payResult;
    /**
     * 支付完成时间 yyyy-MM-dd HH:mm:ss
     */
    private String paySuccessDate;

    //聚合支付字段
    /**
     * 支付链接
     */
    private String payUrl;

    /**
     * 二维码类型
     */
    private String qrCodeType;
    /**
     * 是否允许退款
     * <p>
     * 0：不允许
     * 1：允许且不需要轮询
     * 2：允许且需要轮询获取结果
     */
    private String allowRefunds;
    /**
     * 是否允许撤销
     * <p>
     * 0：不允许
     * 1：允许且不需要轮询
     * 2：允许且需要轮询获取结果
     */
    private String allowCancel;

    public JSONObject buildJson(){
        return  PaymentUtils.toJson(this);
    }


    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public int getAmount() {
        return amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public String getCustomParam() {
        return customParam;
    }

    public void setCustomParam(String customParam) {
        this.customParam = customParam;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Boolean getNeedQuery() {
        return needQuery;
    }

    public void setNeedQuery(Boolean needQuery) {
        this.needQuery = needQuery;
    }

    public String getPayResult() {
        return payResult;
    }

    public void setPayResult(String payResult) {
        this.payResult = payResult;
    }

    public String getPayUrl() {
        return payUrl;
    }

    public void setPayUrl(String payUrl) {
        this.payUrl = payUrl;
    }

    public String getPaySuccessDate() {
        return paySuccessDate;
    }

    public void setPaySuccessDate(String paySuccessDate) {
        this.paySuccessDate = paySuccessDate;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public JSONObject getRequestJson() {
        return requestJson;
    }

    public void setRequestJson(JSONObject requestJson) {
        this.requestJson = requestJson;
    }

    public String getAllowRefunds() {
        return allowRefunds;
    }

    public void setAllowRefunds(String allowRefunds) {
        this.allowRefunds = allowRefunds;
    }

    public String getAllowCancel() {
        return allowCancel;
    }

    public void setAllowCancel(String allowCancel) {
        this.allowCancel = allowCancel;
    }

    public void setState(PaymentStatus paymentStatus) {
        this.code = paymentStatus.getCode();
        this.message = paymentStatus.getMessage();
    }

    public String getQrCodeType() {
        return qrCodeType;
    }

    public void setQrCodeType(String qrCodeType) {
        this.qrCodeType = qrCodeType;
    }
}
