package com.af.v4.system.common.payment.enums;

/**
 * @Project SystemV4
 * @ClassName ResultCodeEnums
 * @Description 统一返回码
 * @Author llz
 * @Date 2024/12/24 17:09
 */
public enum PaymentStatus {
    // 公共
    PAY_SUCCESS("0000", "交易成功"),
    PAY_FAIL("9999", "交易失败"),
    COMMUNICATION_FAIL("9998", "通信失败"),
    VERIFY_SIGN_FAIL("9997", "验签失败"),
    CONNECT_TIME_OUT("9996", "交易超时"),
    SIGN_FAIL("9995", "签名失败"),
    INVALID_CONNECTION_METHOD_OR_BANK_NAME("9994","无效的对接方式或银行名称"),
    INVALID_ORGNAME("9993","无效的分公司名称"),
    //支付状态
    REFUND_FOR_PAYMENT("8889","转入退款"),
    SUCCESS_FOR_PAYMENT("8888", "支付成功"),
    CANCEL_FOR_PAYMENT("8887", "订单无效"),
    PAYMENT_IN_PROGRESS("8886", "支付中"),
    NOT_FOR_PAYMENT("8885", "未支付"),
    FAIL_FOR_PAYMENT("8884","支付失败"),
    ORDER_BEEN_CLOSED("8883", "订单已关闭"),
    //支付订单
    PAY_ORDER_TIMEOUT("1001", "支付订单处理超时，请稍候重试"),
    PAY_ORDER_FAILURE("1002", "支付处理失败，请稍后重试"),
    PAY_ORDER_BUILD_REQUEST_PARAM_ERROR("1003", "构建支付订单请求参数异常"),
    PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR("1004", "构建支付订单返回参数异常"),
    PAY_ORDER_ERROR("1500","支付订单请求异常！"),

    //订单查询
    QUERY_ORDER_TIMEOUT("2001", "查询订单支付状态处理超时，请稍候重试"),
    QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR("2002", "构建查询订单支付状态请求参数异常"),
    QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR("2002", "构建查询订单支付状态返回参数异常"),
    QUERY_ORDER_FAIL("2999", "查询订单支付状态失败，请稍候重试"),
    //订单撤销
    CANCEL_ORDER_TIMEOUT("3001", "撤销订单处理超时，请稍候重试"),
    CANCEL_ORDER_BUILD_REQUEST_PARAM_ERROR("3002", "构建撤销订单请求参数异常"),
    CANCEL_ORDER_BUILD_RESPONSE_PARAM_ERROR("3003", "构建撤销订单返回参数异常"),
    CANCEL_ORDER_SUCCESS("3888", "撤销成功"),
    CANCEL_ORDER_FAIL("3999", "撤销失败"),
    //退款
    REFUND_TIMEOUT("4001", "退款处理超时，请稍候重试"),
    REFUND_BUILD_REQUEST_PARAM_ERROR("4002", "构建退款请求参数异常"),
    REFUND_BUILD_RESPONSE_PARAM_ERROR("4003", "构建退款返回参数异常"),
    //退款状态
    REFUND_REQUEST_SUCCESS("4889", "退款申请成功"),
    REFUND_SUCCESS("4888", "退款成功"),
    REFUND_FAIL("4999", "退款失败"),
    REFUND_REQUEST_FAIL("4998", "退款申请失败"),
    REFUND_PROCESSING("4887","退款中"),
    //退款到银行发现用户的卡作废或者冻结了，导致原路退款银行卡失败，
    // 资金回流到商户的现金帐号，
    // 需要商户人工干预，通过线下或者平台转账的方式进行退款。
    REFUND_CHANGE("4866","转入代发-无法通过接口退款，只能人工处理"),
    //退款状态查询
    QUERY_REFUND_TIMEOUT("5001", "退款状态查询处理超时，请稍候重试"),
    QUERY_REFUND_BUILD_REQUEST_PARAM_ERROR("5002", "构建退款状态查询请求参数异常"),
    QUERY_REFUND_BUILD_RESPONSE_PARAM_ERROR("5003", "构建退款状态查询返回参数异常"),
    QUERY_REFUND_SUCCESS("5888", "退款状态查询成功"),
    QUERY_REFUND_FAIL("5999", "退款状态查询失败");



    // 状态码(交易状态)
    private final String code;
    // 状态描述
    private final String message;

    PaymentStatus(String code, String message) {
        this.code = code;
        this.message = message;
    }


    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
