/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.handler.impl.ccb;

import ccb.pay.api.util.CCBPayUtil;
import com.af.v4.system.common.payment.annotation.PaymentHandlerConfig;
import com.af.v4.system.common.payment.dto.CancelPaymentRequest;
import com.af.v4.system.common.payment.dto.CancelPaymentResponse;
import com.af.v4.system.common.payment.dto.PaymentOrderRequest;
import com.af.v4.system.common.payment.dto.PaymentOrderResponse;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusRequest;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusResponse;
import com.af.v4.system.common.payment.dto.QueryRefundStatusRequest;
import com.af.v4.system.common.payment.dto.QueryRefundStatusResponse;
import com.af.v4.system.common.payment.dto.RefundPaymentRequest;
import com.af.v4.system.common.payment.dto.RefundPaymentResponse;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.handler.impl.AbstractPaymentHandler;
import com.af.v4.system.common.plugins.http.RestTools;
import java.util.Objects;
import org.json.JSONObject;
import org.json.JSONParserConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@PaymentHandlerConfig(bankName=BankName.XJ_CCB, integrationType=IntegrationType.SCAN_DEVICE)
public class XjCcbAbstractPaymentHandlerImpl
extends AbstractPaymentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XjCcbAbstractPaymentHandlerImpl.class);
    JSONParserConfiguration JSON_CONFIG = new JSONParserConfiguration().setOrdered(true);

    @Override
    protected JSONObject buildPayOrderRequestParams(PaymentOrderRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u626b\u7801\u6536\u6b3e\u8bf7\u6c42\u53c2\u6570");
        try {
            return new JSONObject(this.JSON_CONFIG).put("TXCODE", (Object)"PAY100").put("MERFLAG", (Object)"1").put("ORDERID", (Object)request.getOrderNo()).put("QRCODE", (Object)request.getAuthCode()).put("AMOUNT", (double)request.getAmount() / 100.0);
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected PaymentOrderResponse processPayOrderResponse(PaymentOrderResponse response, PaymentOrderRequest request, JSONObject resultJson) {
        LOGGER.info(">>> \u5904\u7406\u4e8c\u7ef4\u7801\u6536\u6b3e\u54cd\u5e94\u7ed3\u679c");
        String res = resultJson.optString("value");
        try {
            JSONObject result = new JSONObject(res);
            if ("N".equals(result.getString("RESULT"))) {
                response.setState(PaymentStatus.PAY_FAIL);
                response.setMessage(result.optString("ERRMSG"));
            } else {
                response.setState(PaymentStatus.PAY_SUCCESS);
                response.setOrderNo(result.optString("TRACEID"));
                response.setAmount((int)Math.round(result.optDouble("AMOUNT") * 100.0));
                response.setQrCodeType(result.optString("QRCODETYPE"));
                response.setTransactionId(result.optString("ORDERID"));
                response.setNeedQuery(true);
                response.setPayResult(PaymentStatus.SUCCESS_FOR_PAYMENT.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            response.setState(PaymentStatus.PAY_FAIL);
            response.setMessage("\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u6570\u636e\u5931\u8d25");
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryPaymentStatusRequestParams(QueryPaymentStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570");
        try {
            String queryTime = Objects.nonNull(request.getCustomParams()) ? request.getCustomParams().optString("qrytime", "1") : "1";
            return new JSONObject(this.JSON_CONFIG).put("TXCODE", (Object)"PAY101").put("MERFLAG", (Object)"1").put("ORDERID", (Object)request.getOrderNo()).put("QRCODETYPE", (Object)request.getCustomParams().optString("qrCodeType", "1")).put("QRCODE", (Object)request.getCustomParams().optString("authCode", "")).put("QRYTIME", (Object)queryTime);
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryPaymentStatusResponse processQueryPaymentStatusResponse(QueryPaymentStatusResponse response, QueryPaymentStatusRequest request, JSONObject resultJson) {
        LOGGER.info(">>> \u5904\u7406\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u54cd\u5e94\u7ed3\u679c");
        String res = resultJson.optString("value");
        try {
            JSONObject result = new JSONObject(res);
            String resCode = result.optString("RESULT", "N");
            if ("Y".equals(resCode)) {
                response.setState(PaymentStatus.SUCCESS_FOR_PAYMENT);
                response.setOrderNo(result.optString("ORDERID"));
                response.setAmount((int)Math.round(result.optDouble("AMOUNT") * 100.0));
                response.setTransactionId(result.optString("ORDERID"));
            } else if ("Q".equals(resCode) || "U".equals(resCode)) {
                response.setState(PaymentStatus.PAYMENT_IN_PROGRESS);
            } else {
                response.setState(PaymentStatus.FAIL_FOR_PAYMENT);
                response.setMessage(result.optString("ERRMSG"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            response.setState(PaymentStatus.PAY_FAIL);
            response.setMessage("\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u6570\u636e\u5931\u8d25");
        }
        return response;
    }

    @Override
    public PaymentOrderResponse paymentOrder(PaymentOrderRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u5f00\u59cb\u6267\u884c\u652f\u4ed8\u8bf7\u6c42\uff01");
        PaymentOrderResponse response = new PaymentOrderResponse();
        try {
            JSONObject reqParams = this.buildPayOrderRequestParams(request, paymentConfig);
            JSONObject payOrderRes = this.executePaymentRequest(reqParams, paymentConfig);
            this.processPayOrderResponse(response, request, payOrderRes);
            return response;
        }
        catch (Exception e) {
            LOGGER.error("\u652f\u4ed8\u5931\u8d25: \u8bf7\u6c42\u62a5\u6587 = {}, \u5f02\u5e38\u4fe1\u606f = {}", (Object)request, (Object)e.getMessage());
            response.setCode(PaymentStatus.PAY_FAIL.getCode());
            response.setMessage(PaymentStatus.PAY_FAIL.getMessage());
            return response;
        }
    }

    @Override
    public QueryPaymentStatusResponse queryPaymentStatus(QueryPaymentStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u5f00\u59cb\u6267\u884c\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\uff01");
        QueryPaymentStatusResponse response = new QueryPaymentStatusResponse();
        try {
            JSONObject reqParams = this.buildQueryPaymentStatusRequestParams(request, paymentConfig);
            JSONObject queryPaymentRes = this.executePaymentRequest(reqParams, paymentConfig);
            this.processQueryPaymentStatusResponse(response, request, queryPaymentRes);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5931\u8d25: \u8bf7\u6c42\u62a5\u6587 = {}, \u5f02\u5e38\u4fe1\u606f = {}", (Object)request, (Object)e.getMessage());
            response.setState(PaymentStatus.QUERY_ORDER_FAIL);
            response.setRequestJson(new JSONObject(request.toString()));
        }
        return response;
    }

    @Override
    protected JSONObject executePaymentRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            LOGGER.info("\u8bf7\u6c42\u652f\u4ed8\u4e1a\u52a1, \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqParams);
            String host = paymentConfig.getString("transactionurl");
            String pubKey = paymentConfig.getString("publicKey");
            String param = this.convertJsonToQueryString(reqParams);
            LOGGER.info(">>> \u53c2\u6570\u4fe1\u606f\uff1a{}", (Object)param);
            String merInfo = this.convertJsonToQueryString(this.getCommonRequest(paymentConfig));
            LOGGER.info(">>> \u5546\u6237\u4fe1\u606f\uff1a{}", (Object)merInfo);
            LOGGER.info(">>> \u516c\u94a5\uff1a{}", (Object)pubKey);
            CCBPayUtil ccbPayUtil = new CCBPayUtil();
            String sign = ccbPayUtil.makeCCBParam(merInfo + "&" + param, pubKey);
            String url = host + "?" + merInfo + "&ccbParam=" + sign;
            LOGGER.info(">>> \u53d1\u9001\u81f3\u94f6\u884c\uff1a{}", (Object)url);
            String notifyURLParam = RestTools.post((String)url, (JSONObject)new JSONObject());
            LOGGER.info(">>> \u94f6\u884c\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)notifyURLParam);
            return new JSONObject().put("value", (Object)notifyURLParam);
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u652f\u4ed8\u4e1a\u52a1\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), reqParams.toString(), PaymentStatus.PAY_ORDER_ERROR.getMessage());
        }
    }

    private JSONObject getCommonRequest(JSONObject paymentConfig) {
        return new JSONObject(this.JSON_CONFIG).put("MERCHANTID", (Object)paymentConfig.optString("mchId")).put("POSID", (Object)paymentConfig.optString("posId")).put("BRANCHID", (Object)paymentConfig.optString("branchId"));
    }

    private String convertJsonToQueryString(JSONObject jsonObject) {
        StringBuilder queryString = new StringBuilder();
        boolean first = true;
        for (String key : jsonObject.keySet()) {
            if (!first) {
                queryString.append("&");
            } else {
                first = false;
            }
            queryString.append(key.toUpperCase()).append("=").append(jsonObject.opt(key));
        }
        return queryString.toString();
    }

    @Override
    protected JSONObject buildCancelOrderRequestParams(CancelPaymentRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected CancelPaymentResponse processCancelOrderResponse(CancelPaymentResponse response, CancelPaymentRequest request, JSONObject resultJson) {
        return null;
    }

    @Override
    protected JSONObject buildRefundOrderRequestParams(RefundPaymentRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected RefundPaymentResponse processRefundOrderResponse(RefundPaymentResponse response, RefundPaymentRequest request, JSONObject resultJson) {
        return null;
    }

    @Override
    protected JSONObject buildQueryRefundStatusRequestParams(QueryRefundStatusRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected QueryRefundStatusResponse processQueryRefundStatusResponse(QueryRefundStatusResponse response, QueryRefundStatusRequest request, JSONObject resultJson) {
        return null;
    }

    @Override
    protected void signRequest(JSONObject reqParams, JSONObject paymentConfig) {
    }

    @Override
    protected boolean verifyResponseSign(JSONObject response, JSONObject paymentConfig) {
        return true;
    }
}

