/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.service;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.payment.config.PaymentConfig;
import com.af.v4.system.common.payment.dto.CancelPaymentRequest;
import com.af.v4.system.common.payment.dto.CancelPaymentResponse;
import com.af.v4.system.common.payment.dto.PaymentOrderRequest;
import com.af.v4.system.common.payment.dto.PaymentOrderResponse;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusRequest;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusResponse;
import com.af.v4.system.common.payment.dto.QueryRefundStatusRequest;
import com.af.v4.system.common.payment.dto.QueryRefundStatusResponse;
import com.af.v4.system.common.payment.dto.RefundPaymentRequest;
import com.af.v4.system.common.payment.dto.RefundPaymentResponse;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.factory.PaymentHandlerFactory;
import com.af.v4.system.common.payment.handler.PaymentHandler;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.redis.RedisService;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaymentService.class);
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private static final int MAX_COUNTER = 99999;
    private final LiuLiConfigService liuLiConfigService;
    private final PaymentConfig paymentConfig;
    private final RedisService redisService;

    public PaymentService(LiuLiConfigService liuLiConfigService, PaymentConfig paymentConfig, RedisService redisService) {
        this.liuLiConfigService = liuLiConfigService;
        this.paymentConfig = paymentConfig;
        this.redisService = redisService;
    }

    public void registerPaymentConfig(JSONObject config) {
        this.paymentConfig.setPaymentConfig(config);
        this.paymentConfig.setBankName(BankName.findByName(config.getString("bankName")));
        this.paymentConfig.setIntegrationType(IntegrationType.findByDescription(config.getString("integrationType")));
    }

    private JSONObject getPaymentConfig(String bankName, String orgName) {
        JSONObject bankConfig;
        JSONObject allConfig = this.liuLiConfigService.get("PaymentConfig", Boolean.valueOf(true));
        if (!allConfig.has(bankName)) {
            LOGGER.warn("\u672a\u83b7\u53d6\u5230\u94f6\u884c\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u7409\u7483\u4e2d\u5fc3\u914d\u7f6e-PaymentConfig");
        }
        if (!(bankConfig = allConfig.getJSONObject(bankName)).has(orgName)) {
            LOGGER.warn("\u672a\u83b7\u53d6\u5230\u5206\u516c\u53f8\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u7409\u7483\u4e2d\u5fc3\u914d\u7f6e-PaymentConfig");
        }
        return bankConfig.getJSONObject(orgName);
    }

    public PaymentOrderResponse paymentOrder(PaymentOrderRequest request) {
        try {
            LOGGER.info("\u5904\u7406\u652f\u4ed8\u8bf7\u6c42 > " + request.getBankName());
            this.registerPaymentConfig(this.getPaymentConfig(request.getBankName(), request.getOrgName()));
            PaymentHandler handler = this.getPaymentHandler(this.paymentConfig.getBankName(), this.paymentConfig.getIntegrationType());
            return handler.paymentOrder(request, this.paymentConfig.getPaymentConfig());
        }
        catch (PaymentException e) {
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), request.toString(), e.getMessage());
        }
    }

    public QueryPaymentStatusResponse queryPaymentStatus(QueryPaymentStatusRequest request) {
        try {
            this.registerPaymentConfig(this.getPaymentConfig(request.getBankName(), request.getOrgName()));
            PaymentHandler handler = this.getPaymentHandler(this.paymentConfig.getBankName(), this.paymentConfig.getIntegrationType());
            return handler.queryPaymentStatus(request, this.paymentConfig.getPaymentConfig());
        }
        catch (Exception e) {
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), request.toString(), e.getMessage());
        }
    }

    public CancelPaymentResponse cancelPayment(CancelPaymentRequest request) {
        try {
            this.registerPaymentConfig(this.getPaymentConfig(request.getBankName(), request.getOrgName()));
            PaymentHandler handler = this.getPaymentHandler(this.paymentConfig.getBankName(), this.paymentConfig.getIntegrationType());
            return handler.cancelOrder(request, this.paymentConfig.getPaymentConfig());
        }
        catch (PaymentException e) {
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), request.toString(), e.getMessage());
        }
    }

    public RefundPaymentResponse refundPayment(RefundPaymentRequest request) {
        try {
            this.registerPaymentConfig(this.getPaymentConfig(request.getBankName(), request.getOrgName()));
            PaymentHandler handler = this.getPaymentHandler(this.paymentConfig.getBankName(), this.paymentConfig.getIntegrationType());
            return handler.refundPayment(request, this.paymentConfig.getPaymentConfig());
        }
        catch (PaymentException e) {
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), request.toString(), e.getMessage());
        }
    }

    public QueryRefundStatusResponse queryRefundStatus(QueryRefundStatusRequest request) {
        try {
            this.registerPaymentConfig(this.getPaymentConfig(request.getBankName(), request.getOrgName()));
            PaymentHandler handler = this.getPaymentHandler(this.paymentConfig.getBankName(), this.paymentConfig.getIntegrationType());
            return handler.queryRefundStatus(request, this.paymentConfig.getPaymentConfig());
        }
        catch (PaymentException e) {
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), request.toString(), e.getMessage());
        }
    }

    private PaymentHandler getPaymentHandler(BankName bankName, IntegrationType integrationType) {
        try {
            return PaymentHandlerFactory.getHandler(bankName, integrationType);
        }
        catch (PaymentException e) {
            throw new PaymentException(PaymentStatus.INVALID_CONNECTION_METHOD_OR_BANK_NAME.getCode(), "{}", PaymentStatus.INVALID_CONNECTION_METHOD_OR_BANK_NAME.getMessage());
        }
    }

    public String generateOrderNumber(int length) {
        String key = "order_number_counter_lock_" + Thread.currentThread().threadId();
        if (length < 20 || length > 30) {
            throw new IllegalArgumentException("\u8ba2\u5355\u53f7\u957f\u5ea6\u5fc5\u987b\u5728 20 \u5230 30 \u4f4d\u4e4b\u95f4\uff01");
        }
        return (String)this.redisService.syncLock(key, () -> {
            StringBuilder orderNumber = new StringBuilder("SN");
            String timestamp = DateTools.getNow((String)"yyyyMMddHHmmssSSS");
            orderNumber.append(timestamp);
            int counterValue = COUNTER.updateAndGet(current -> {
                if (current >= 99999) {
                    return 0;
                }
                return current + 1;
            });
            if (counterValue > 99999) {
                COUNTER.set(0);
                counterValue = COUNTER.getAndIncrement();
            }
            String counterString = String.format("%05d", counterValue);
            orderNumber.append(counterString);
            int remainingLength = length - orderNumber.length();
            if (remainingLength > 0) {
                String randomString = this.generateRandomDigits(remainingLength);
                orderNumber.append(randomString);
            }
            return orderNumber.toString();
        });
    }

    public String generateRandomDigits(int length) {
        StringBuilder randomDigits = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int randomDigit = (int)(Math.random() * 10.0);
            randomDigits.append(randomDigit);
        }
        return randomDigits.toString();
    }
}

