/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.handler.impl;

import com.af.v4.system.common.payment.dto.CancelPaymentRequest;
import com.af.v4.system.common.payment.dto.CancelPaymentResponse;
import com.af.v4.system.common.payment.dto.PaymentOrderRequest;
import com.af.v4.system.common.payment.dto.PaymentOrderResponse;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusRequest;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusResponse;
import com.af.v4.system.common.payment.dto.QueryRefundStatusRequest;
import com.af.v4.system.common.payment.dto.QueryRefundStatusResponse;
import com.af.v4.system.common.payment.dto.RefundPaymentRequest;
import com.af.v4.system.common.payment.dto.RefundPaymentResponse;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.handler.PaymentHandler;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPaymentHandler
implements PaymentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPaymentHandler.class);

    @Override
    public PaymentOrderResponse paymentOrder(PaymentOrderRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u5f00\u59cb\u6267\u884c\u652f\u4ed8\u8bf7\u6c42\uff01");
        PaymentOrderResponse response = new PaymentOrderResponse();
        try {
            JSONObject reqParams = this.buildPayOrderRequestParams(request, paymentConfig);
            this.signRequest(reqParams, paymentConfig);
            JSONObject payOrderRes = this.executePaymentRequest(reqParams, paymentConfig);
            if (!this.verifyResponseSign(payOrderRes, paymentConfig)) {
                throw new PaymentException(PaymentStatus.VERIFY_SIGN_FAIL.getCode(), PaymentStatus.VERIFY_SIGN_FAIL.getMessage(), request.toString());
            }
            this.processPayOrderResponse(response, request, payOrderRes);
        }
        catch (Exception e) {
            LOGGER.error("\u652f\u4ed8\u5931\u8d25: \u8bf7\u6c42\u62a5\u6587={}, \u5f02\u5e38\u4fe1\u606f={}", (Object)request, (Object)e.getMessage());
            response.setCode(PaymentStatus.PAY_FAIL.getCode());
            response.setMessage(PaymentStatus.PAY_FAIL.getMessage());
            response.setRequestJson(new JSONObject(request.toString()));
        }
        return response;
    }

    @Override
    public QueryPaymentStatusResponse queryPaymentStatus(QueryPaymentStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u5f00\u59cb\u6267\u884c\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\uff01");
        QueryPaymentStatusResponse response = new QueryPaymentStatusResponse();
        JSONObject queryPaymentRes = null;
        try {
            JSONObject reqParams = this.buildQueryPaymentStatusRequestParams(request, paymentConfig);
            this.signRequest(reqParams, paymentConfig);
            queryPaymentRes = this.executePaymentRequest(reqParams, paymentConfig);
            if (!this.verifyResponseSign(queryPaymentRes, paymentConfig)) {
                throw new PaymentException(PaymentStatus.VERIFY_SIGN_FAIL.getCode(), PaymentStatus.VERIFY_SIGN_FAIL.getMessage(), request.toString());
            }
            this.processQueryPaymentStatusResponse(response, request, queryPaymentRes);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5931\u8d25: \u8bf7\u6c42\u62a5\u6587={}, \u5f02\u5e38\u4fe1\u606f={}", (Object)request, (Object)e.getMessage());
            response.setCode(PaymentStatus.QUERY_ORDER_FAIL.getCode());
            response.setMessage(PaymentStatus.QUERY_ORDER_FAIL.getMessage());
            response.setRequestJson(new JSONObject(request.toString()));
        }
        return response;
    }

    @Override
    public final CancelPaymentResponse cancelOrder(CancelPaymentRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u5f00\u59cb\u6267\u884c\u8ba2\u5355\u64a4\u9500\u8bf7\u6c42\uff01");
        CancelPaymentResponse response = new CancelPaymentResponse();
        try {
            JSONObject reqParams = this.buildCancelOrderRequestParams(request, paymentConfig);
            this.signRequest(reqParams, paymentConfig);
            JSONObject queryPaymentRes = this.executePaymentRequest(reqParams, paymentConfig);
            if (!this.verifyResponseSign(queryPaymentRes, paymentConfig)) {
                throw new PaymentException(PaymentStatus.VERIFY_SIGN_FAIL.getCode(), PaymentStatus.VERIFY_SIGN_FAIL.getMessage(), request.toString());
            }
            this.processCancelOrderResponse(response, request, queryPaymentRes);
        }
        catch (Exception e) {
            LOGGER.error("\u8ba2\u5355\u64a4\u9500\u5931\u8d25: \u8bf7\u6c42\u62a5\u6587={}, \u5f02\u5e38\u4fe1\u606f={}", (Object)request, (Object)e.getMessage());
            response.setCode(PaymentStatus.QUERY_ORDER_FAIL.getCode());
            response.setMessage(PaymentStatus.QUERY_ORDER_FAIL.getMessage());
            response.setRequestJson(new JSONObject(request.toString()));
        }
        return response;
    }

    @Override
    public final RefundPaymentResponse refundPayment(RefundPaymentRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u5f00\u59cb\u6267\u884c\u8ba2\u5355\u9000\u6b3e\u8bf7\u6c42\uff01");
        RefundPaymentResponse response = new RefundPaymentResponse();
        try {
            JSONObject reqParams = this.buildRefundOrderRequestParams(request, paymentConfig);
            this.signRequest(reqParams, paymentConfig);
            JSONObject queryPaymentRes = this.executePaymentRequest(reqParams, paymentConfig);
            if (!this.verifyResponseSign(queryPaymentRes, paymentConfig)) {
                throw new PaymentException(PaymentStatus.VERIFY_SIGN_FAIL.getCode(), PaymentStatus.VERIFY_SIGN_FAIL.getMessage(), request.toString());
            }
            this.processRefundOrderResponse(response, request, queryPaymentRes);
        }
        catch (Exception e) {
            LOGGER.error("\u8ba2\u5355\u9000\u6b3e\u5931\u8d25: \u8bf7\u6c42\u62a5\u6587={}, \u5f02\u5e38\u4fe1\u606f={}", (Object)request, (Object)e.getMessage());
            response.setCode(PaymentStatus.QUERY_ORDER_FAIL.getCode());
            response.setMessage(PaymentStatus.QUERY_ORDER_FAIL.getMessage());
            response.setRequestJson(new JSONObject(request.toString()));
        }
        return response;
    }

    @Override
    public final QueryRefundStatusResponse queryRefundStatus(QueryRefundStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u5f00\u59cb\u6267\u884c\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u8bf7\u6c42\uff01");
        QueryRefundStatusResponse response = new QueryRefundStatusResponse();
        try {
            JSONObject reqParams = this.buildQueryRefundStatusRequestParams(request, paymentConfig);
            this.signRequest(reqParams, paymentConfig);
            JSONObject queryPaymentRes = this.executePaymentRequest(reqParams, paymentConfig);
            if (!this.verifyResponseSign(queryPaymentRes, paymentConfig)) {
                throw new PaymentException(PaymentStatus.VERIFY_SIGN_FAIL.getCode(), PaymentStatus.VERIFY_SIGN_FAIL.getMessage(), request.toString());
            }
            this.processQueryRefundStatusResponse(response, request, queryPaymentRes);
        }
        catch (Exception e) {
            LOGGER.warn("\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u5931\u8d25: \u8bf7\u6c42\u62a5\u6587={},\u5f02\u5e38\u4fe1\u606f={}", (Object)request, (Object)e.getMessage());
            response.setCode(PaymentStatus.QUERY_ORDER_FAIL.getCode());
            response.setMessage(PaymentStatus.QUERY_ORDER_FAIL.getMessage());
            response.setRequestJson(new JSONObject(request.toString()));
        }
        return response;
    }

    protected abstract JSONObject buildPayOrderRequestParams(PaymentOrderRequest var1, JSONObject var2);

    protected abstract PaymentOrderResponse processPayOrderResponse(PaymentOrderResponse var1, PaymentOrderRequest var2, JSONObject var3);

    protected abstract JSONObject buildQueryPaymentStatusRequestParams(QueryPaymentStatusRequest var1, JSONObject var2);

    protected abstract QueryPaymentStatusResponse processQueryPaymentStatusResponse(QueryPaymentStatusResponse var1, QueryPaymentStatusRequest var2, JSONObject var3);

    protected abstract JSONObject buildCancelOrderRequestParams(CancelPaymentRequest var1, JSONObject var2);

    protected abstract CancelPaymentResponse processCancelOrderResponse(CancelPaymentResponse var1, CancelPaymentRequest var2, JSONObject var3);

    protected abstract JSONObject buildRefundOrderRequestParams(RefundPaymentRequest var1, JSONObject var2);

    protected abstract RefundPaymentResponse processRefundOrderResponse(RefundPaymentResponse var1, RefundPaymentRequest var2, JSONObject var3);

    protected abstract JSONObject buildQueryRefundStatusRequestParams(QueryRefundStatusRequest var1, JSONObject var2);

    protected abstract QueryRefundStatusResponse processQueryRefundStatusResponse(QueryRefundStatusResponse var1, QueryRefundStatusRequest var2, JSONObject var3);

    protected abstract void signRequest(JSONObject var1, JSONObject var2);

    protected abstract JSONObject executePaymentRequest(JSONObject var1, JSONObject var2);

    protected abstract boolean verifyResponseSign(JSONObject var1, JSONObject var2);
}

