/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.dto;

import org.json.JSONObject;

public class RefundPaymentRequest {
    private final String orderNo;
    private final String refundOrderNo;
    private final int amount;
    private final int refundAmount;
    private final String bankName;
    private final String orgName;

    private RefundPaymentRequest(Builder builder) {
        this.orderNo = builder.orderNo;
        this.refundOrderNo = builder.refundOrderNo;
        this.amount = builder.amount;
        this.refundAmount = builder.refundAmount;
        this.bankName = builder.bankName;
        this.orgName = builder.orgName;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public String getRefundOrderNo() {
        return this.refundOrderNo;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getRefundAmount() {
        return this.refundAmount;
    }

    public static class Builder {
        private String orderNo;
        private String refundOrderNo;
        private int amount;
        private int refundAmount;
        private String bankName;
        private String orgName;

        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("orderNo")) {
                builder.orderNo(jsonObject.getString("orderNo"));
            }
            if (jsonObject.has("refundOrderNo")) {
                builder.refundOrderNo(jsonObject.getString("refundOrderNo"));
            }
            if (jsonObject.has("amount")) {
                builder.amount(jsonObject.getInt("amount"));
            }
            if (jsonObject.has("refundAmount")) {
                builder.refundAmount(jsonObject.getInt("refundAmount"));
            }
            if (jsonObject.has("bankName")) {
                builder.bankName(jsonObject.getString("bankName"));
            }
            if (jsonObject.has("orgName")) {
                builder.orgName(jsonObject.getString("orgName"));
            }
            return builder;
        }

        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public Builder refundOrderNo(String refundOrderNo) {
            this.refundOrderNo = refundOrderNo;
            return this;
        }

        public Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public Builder refundAmount(int refundAmount) {
            this.refundAmount = refundAmount;
            return this;
        }

        public Builder orgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public Builder bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        public RefundPaymentRequest build() {
            return new RefundPaymentRequest(this);
        }
    }
}

