package com.af.v4.system.common.payment.dto;

import org.json.JSONObject;

/**
 * @author llzh
 * @ClassName PaymentQueryRequest
 * @Description 查询订单状态请求参数
 * @DateTime 2024/12/25 13:36
 */
public class QueryPaymentStatusRequest {
    /**
     * 商户订单号（业务系统生成的唯一订单号）
     */
    private final String orderNo;
    private final String transactionId;
    /**
     * 银行名称
     */
    private final String bankName;
    /**
     * 分公司名称
     */
    private final String orgName;

    // 私有构造函数，防止直接实例化
    private QueryPaymentStatusRequest(Builder builder) {
        this.orderNo = builder.orderNo;
        this.bankName = builder.bankName;
        this.orgName = builder.orgName;
        this.transactionId = builder.transactionId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public String getBankName() {
        return bankName;
    }

    public String getOrgName() {
        return orgName;
    }
    public String getTransactionId() {
        return transactionId;
    }

    // Builder 静态内部类
    public static class Builder {
        private String orderNo;
        private String bankName;
        private String orgName;
        private String transactionId;

        public Builder() {
        }

        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("orderNo")) {
                builder.orderNo(jsonObject.getString("orderNo"));
            }
            if (jsonObject.has("bankName")) {
                builder.bankName(jsonObject.getString("bankName"));
            }
            if (jsonObject.has("orgName")) {
                builder.orgName(jsonObject.getString("orgName"));
            }
            if (jsonObject.has("transactionId")) {
                builder.transactionId(jsonObject.getString("transactionId"));
            }
            return builder;

        }

        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }


        public Builder orgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public Builder bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }
        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }
        public QueryPaymentStatusRequest build() {
            return new QueryPaymentStatusRequest(this);
        }
    }
}