/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.mq;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.proxy.logic.ILogicServiceProxy;
import com.af.v4.system.common.core.utils.uuid.IdUtils;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RocketMQProducer {
    public static final String DEFAULT_LOGIC_TOPIC = "AF_LOGIC_TOPIC";
    private static final Logger LOGGER = LoggerFactory.getLogger(RocketMQProducer.class);
    private final RocketMQTemplate rocketMQTemplate;
    private final ILogicServiceProxy logicService;

    public RocketMQProducer(RocketMQTemplate rocketMQTemplate, ILogicServiceProxy logicService) {
        this.rocketMQTemplate = rocketMQTemplate;
        this.logicService = logicService;
    }

    public JSONObject syncSend(String topic, String tags, String value) {
        Message msg = new Message(topic, tags, value.getBytes(StandardCharsets.UTF_8));
        msg.setKeys(IdUtils.fastSimpleUUID());
        msg.setDeliverTimeMs(0L);
        SendResult sendResult = this.rocketMQTemplate.syncSend(topic + ":" + tags, (Object)msg);
        JSONObject result = new JSONObject();
        result.put("msgId", (Object)sendResult.getMsgId());
        result.put("sendStatus", (Object)sendResult.getSendStatus().name());
        return result;
    }

    @Log(title="MQ\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    public void asyncSend(String topic, String tags, String value, String callbackLogicName) {
        this.asyncSend(topic, tags, value, (SendResult sendResult) -> this.logicService.run(callbackLogicName, this.parseMsgResult(sendResult).toString()));
    }

    public void asyncSend(String topic, String tags, String value, final Function successFunction) {
        Message msg = new Message(topic, tags, value.getBytes(StandardCharsets.UTF_8));
        msg.setKeys(IdUtils.fastSimpleUUID());
        msg.setDeliverTimeMs(0L);
        this.rocketMQTemplate.asyncSend(topic + ":" + tags, (Object)msg, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                successFunction.callback(sendResult);
            }

            public void onException(Throwable e) {
                String msg = "\u961f\u5217\u6d88\u606f\u53d1\u9001\u5931\u8d25";
                LOGGER.error(msg, e);
                throw new ServiceException(msg);
            }
        });
    }

    public void sendOneway(String topic, String tags, String value) {
        Message msg = new Message(topic, tags, value.getBytes(StandardCharsets.UTF_8));
        msg.setKeys(IdUtils.fastSimpleUUID());
        msg.setDeliverTimeMs(0L);
        this.rocketMQTemplate.sendOneWay(topic + ":" + tags, (Object)msg);
    }

    private JSONObject parseMsgResult(SendResult sendResult) {
        JSONObject result = new JSONObject();
        result.put("msgId", (Object)sendResult.getMsgId());
        result.put("sendStatus", (Object)sendResult.getSendStatus().name());
        return result;
    }

    public static interface Function {
        public void callback(SendResult var1);
    }
}

