package com.af.v4.system.common.mq;

import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.plugins.core.ConvertTools;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.nio.charset.StandardCharsets;

/**
 * Logic消息消费监听器
 *
 * @author Mr.river
 */
@Component
@RocketMQMessageListener(topic = RocketMQProducer.DEFAULT_LOGIC_TOPIC, consumerGroup = "${spring.application.name:}-GROUP")
public class LogicMessageListener implements RocketMQListener<MessageExt> {
    /**
     * 日志对象
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicMessageListener.class);
    private final LogicService logicService;

    public LogicMessageListener(LogicService logicService) {
        this.logicService = logicService;
    }

    @Override
    public void onMessage(MessageExt message) {
        //消费Logic请求
        String logicName = message.getTags();
        String body = new String(message.getBody(), StandardCharsets.UTF_8);
        JSONObject content = new JSONObject(
                new String(ConvertTools.base64Decode(
                        new JSONObject(body).getString("body").getBytes(StandardCharsets.UTF_8)
                ), StandardCharsets.UTF_8)
        );
        try {
            logicService.run(logicName, content);
        } catch (Exception e) {
            LOGGER.error("【{}】出现异常：", logicName, e);
            throw e;
        }
    }
}
