/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.mq;

import com.af.v4.system.common.core.proxy.logic.ILogicServiceProxy;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.log.enums.OperatorType;
import com.af.v4.system.common.log.service.LogResolveService;
import com.af.v4.system.common.plugins.core.ConvertTools;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="rocketmq", name={"name-server"})
@RocketMQMessageListener(topic="AF_LOGIC_TOPIC", consumerGroup="${spring.application.name:}-GROUP")
public class LogicMessageListener
implements RocketMQListener<MessageExt> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicMessageListener.class);
    private final ILogicServiceProxy logicService;
    private final LogResolveService logResolveService;

    public LogicMessageListener(ILogicServiceProxy logicService, LogResolveService logResolveService) {
        this.logicService = logicService;
        this.logResolveService = logResolveService;
    }

    public void onMessage(MessageExt message) {
        long beginTime = System.currentTimeMillis();
        String logicName = message.getTags();
        String body = new String(message.getBody(), StandardCharsets.UTF_8);
        JSONObject content = new JSONObject(new String(ConvertTools.base64Decode((byte[])new JSONObject(body).getString("body").getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        try {
            this.logicService.run(logicName, content);
            long endTime = System.currentTimeMillis();
            this.handleLog(logicName, content, null, endTime - beginTime);
        }
        catch (Exception e) {
            LOGGER.error("\u3010{}\u3011\u51fa\u73b0\u5f02\u5e38\uff1a", (Object)logicName, (Object)e);
            long endTime = System.currentTimeMillis();
            this.handleLog(logicName, content, e, endTime - beginTime);
            throw e;
        }
    }

    protected void handleLog(String logicName, Object operParams, Throwable e, long costTime) {
        this.logResolveService.resolveLog(this.getClass().getName(), "onMessage", BusinessType.LOGIC.name(), "MQ\u6d88\u8d39Logic\uff1a" + logicName, OperatorType.SYSTEM.name(), operParams.toString(), costTime, e);
    }
}

