/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.mq.rabbitMQ;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.uuid.IdUtils;
import com.af.v4.system.common.mq.rabbitMQ.MultiRabbitConnectionManager;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="rabbitmq", name={"enabled"}, havingValue="true")
public class MultiRabbitProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiRabbitProducer.class);
    private final MultiRabbitConnectionManager connectionManager;

    public MultiRabbitProducer(MultiRabbitConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public JSONObject sendToConnection(String connectionName, String exchange, String routingKey, String message) {
        try {
            RabbitTemplate template = this.connectionManager.getRabbitTemplate(connectionName);
            MessageProperties properties = new MessageProperties();
            properties.setMessageId(IdUtils.fastSimpleUUID());
            properties.setContentType("text/plain");
            Message msg = new Message(message.getBytes(), properties);
            template.send(exchange, routingKey, msg);
            JSONObject result = new JSONObject();
            result.put("messageId", (Object)properties.getMessageId());
            result.put("success", true);
            result.put("connectionName", (Object)connectionName);
            result.put("exchange", (Object)exchange);
            result.put("routingKey", (Object)routingKey);
            LOGGER.debug("[RabbitMQ] \u6d88\u606f\u53d1\u9001\u6210\u529f: \u8fde\u63a5=[{}], messageId={}", (Object)connectionName, (Object)properties.getMessageId());
            return result;
        }
        catch (Exception e) {
            LOGGER.error("[RabbitMQ] \u6d88\u606f\u53d1\u9001\u5931\u8d25: \u8fde\u63a5=[{}], exchange={}, routingKey={}", new Object[]{connectionName, exchange, routingKey, e});
            throw new ServiceException("RabbitMQ\u6d88\u606f\u53d1\u9001\u5931\u8d25: " + e.getMessage());
        }
    }

    public JSONObject sendToQueue(String connectionName, String queueName, String message) {
        return this.sendToConnection(connectionName, "", queueName, message);
    }

    public JSONObject sendJsonToConnection(String connectionName, String exchange, String routingKey, JSONObject data) {
        try {
            RabbitTemplate template = this.connectionManager.getRabbitTemplate(connectionName);
            MessageProperties properties = new MessageProperties();
            properties.setMessageId(IdUtils.fastSimpleUUID());
            properties.setContentType("application/json");
            Message msg = new Message(data.toString().getBytes(), properties);
            template.send(exchange, routingKey, msg);
            JSONObject result = new JSONObject();
            result.put("messageId", (Object)properties.getMessageId());
            result.put("success", true);
            result.put("connectionName", (Object)connectionName);
            result.put("exchange", (Object)exchange);
            result.put("routingKey", (Object)routingKey);
            LOGGER.debug("[RabbitMQ] JSON\u6d88\u606f\u53d1\u9001\u6210\u529f: \u8fde\u63a5=[{}], messageId={}", (Object)connectionName, (Object)properties.getMessageId());
            return result;
        }
        catch (Exception e) {
            LOGGER.error("[RabbitMQ] JSON\u6d88\u606f\u53d1\u9001\u5931\u8d25: \u8fde\u63a5=[{}], exchange={}, routingKey={}", new Object[]{connectionName, exchange, routingKey, e});
            throw new ServiceException("RabbitMQ JSON\u6d88\u606f\u53d1\u9001\u5931\u8d25: " + e.getMessage());
        }
    }

    public boolean isConnectionAvailable(String connectionName) {
        return this.connectionManager.hasConnection(connectionName);
    }
}

