package com.af.v4.system.common.mq;

import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.stereotype.Component;

import java.nio.charset.StandardCharsets;

/**
 * RocketMQ生产者
 */
@Component
public class RocketMQProducer {

    private final RocketMQTemplate rocketMQTemplate;

    public RocketMQProducer(RocketMQTemplate rocketMQTemplate) {
        this.rocketMQTemplate = rocketMQTemplate;
    }

    /**
     * 发送单向消息
     *
     * @param topic       topic
     * @param tags        tags
     * @param value       内容
     * @param destination 描述
     */
    public void sendOneway(String topic, String tags, String value, String destination) {
        Message msg = new Message(topic, tags, value.getBytes(StandardCharsets.UTF_8));
        // 发送单向消息
        rocketMQTemplate.sendOneWay(destination, msg);
    }
}
