/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.mongodb.service;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;

@Component
public class MongodbService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongodbService.class);
    private final MongoTemplate mongoTemplate;

    public MongodbService(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public String save(JSONObject value, String collectionName) {
        Map result = (Map)this.mongoTemplate.save((Object)value.toMap(), collectionName);
        ObjectId id = (ObjectId)result.get("_id");
        return id.toString();
    }

    public JSONArray save(JSONArray value, String collectionName) {
        JSONArray resultIds = new JSONArray(value.length());
        value.forEach(item -> {
            Map result = (Map)this.mongoTemplate.save((Object)((JSONObject)item).toMap(), collectionName);
            ObjectId id = (ObjectId)result.get("_id");
            resultIds.put((Object)id);
        });
        return resultIds;
    }

    public Long update(String id, JSONObject updateContent, String collectionName) {
        Update update = new Update();
        updateContent.toMap().forEach((arg_0, arg_1) -> ((Update)update).set(arg_0, arg_1));
        UpdateResult updateResult = this.mongoTemplate.updateMulti(SimpleQuery.byId(id), (UpdateDefinition)update, collectionName);
        return updateResult.getModifiedCount();
    }

    public Long update(Criteria criteria, JSONObject updateContent, String collectionName) {
        Update update = new Update();
        updateContent.toMap().forEach((arg_0, arg_1) -> ((Update)update).set(arg_0, arg_1));
        UpdateResult updateResult = this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)criteria), (UpdateDefinition)update, collectionName);
        return updateResult.getModifiedCount();
    }

    public Long removeOne(String id, String collectionName) {
        DeleteResult result = this.mongoTemplate.remove(SimpleQuery.byId(id), Map.class, collectionName);
        return result.getDeletedCount();
    }

    public Long removeByIds(JSONArray ids, String collectionName) {
        DeleteResult result = this.mongoTemplate.remove(SimpleQuery.byIds(ids.toList()), Map.class, collectionName);
        return result.getDeletedCount();
    }

    public Long remove(Criteria criteria, String collectionName) {
        DeleteResult result = this.mongoTemplate.remove(new Query((CriteriaDefinition)criteria), Map.class, collectionName);
        return result.getDeletedCount();
    }

    public JSONObject findOne(String id, String collectionName) {
        Map result = (Map)this.mongoTemplate.findById((Object)new ObjectId(id), Map.class, collectionName);
        if (result != null) {
            result.put("_id", result.get("_id").toString());
        }
        return new JSONObject(result);
    }

    public JSONArray findByIds(JSONArray ids, String collectionName) {
        List<Map> result = this.mongoTemplate.find(SimpleQuery.byIds(ids.toList()), Map.class, collectionName).stream().peek(item -> item.put("_id", item.get("_id").toString())).toList();
        return new JSONArray(result);
    }

    public JSONArray find(Criteria criteria, String collectionName) {
        List<Map> result = this.mongoTemplate.find(new Query((CriteriaDefinition)criteria), Map.class, collectionName).stream().peek(item -> item.put("_id", item.get("_id").toString())).toList();
        return new JSONArray(result);
    }

    public JSONArray aggregate(Aggregation aggregation, String collectionName) {
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, Map.class);
        JSONArray jsonArray = new JSONArray();
        for (Map map : results) {
            jsonArray.put((Object)new JSONObject(map));
        }
        return jsonArray;
    }

    public static class SimpleQuery {
        public static Query byId(String id) {
            return new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
        }

        public static Query byIds(Collection<?> ids) {
            return new Query((CriteriaDefinition)Criteria.where((String)"_id").in(ids.stream().map(item -> new ObjectId(item.toString())).toList()));
        }
    }
}

