package com.af.v4.system.common.mobile.controller;

import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.jpa.session.SessionPool;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;


/**
 * 元数据服务
 */
@RestController
@RequestMapping("/db")
public class MobileEntitySyncController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MobileEntitySyncController.class);

    private final EntityService entityService;

    private final SessionPool sessionPool;

    public MobileEntitySyncController(EntityService entityService, SessionPool sessionPool) {
        this.entityService = entityService;
        this.sessionPool = sessionPool;
    }

    @Log(title = "meta2", businessType = BusinessType.OTHER)
    @RequestMapping(value = "/meta2", produces = MediaType.APPLICATION_JSON_VALUE)
    public String getMetaOfTables() {
        entityService.loadAllMetaData();
        Map<String, String> leftMap = EntityService.getEntityLiftMap();
        Map<String, Map<String, Object>> metaMap = EntityService.getMetaMap();
        Map<String, Object> map = new HashMap<>();
        for (String key : leftMap.keySet()) {
            map.put(key, leftMap.get(key));
        }
        metaMap.put("_entityLiftMap_", map);
        return new JSONObject(metaMap).toString();
    }

    @Log(title = "meta", businessType = BusinessType.OTHER)
    @PostMapping(value = "/meta", produces = MediaType.APPLICATION_JSON_VALUE)
    public String getMetaOfTables(String tables) {
        return getMeta(tables).toString();
    }

    /**
     * 得到实体的元数据和关联信息
     *
     * @param entityName 实体名称
     * @return 元数据和关联信息
     */
    public JSONObject getMeta(String entityName) {
        String[] entities = entityName.split(",");

        JSONObject result = new JSONObject();

        for (String entity : entities) {
            JSONArray associations = new JSONArray();
            JSONArray columns = new JSONArray();
            SessionFactoryImpl sessionFactory = sessionPool.getSessionFactory();
            MappingMetamodel metamodel = sessionFactory.getMappingMetamodel();
            EntityPersister cmd = metamodel.getEntityDescriptor(entity);
            JSONObject joProperties = new JSONObject();
            //记录表名
            joProperties.put("__table__", removeSchema(((AbstractEntityPersister) cmd).getTableName()));
            joProperties.put("__columns__", columns);
            for (String property : cmd.getPropertyNames()) {
                Type type = cmd.getPropertyType(property);
                if (type instanceof CollectionType st) {
                    //获取关联字段
                    AbstractEntityPersister ja = (AbstractEntityPersister) st.getAssociatedJoinable(sessionFactory);
                    String idName = cmd.getIdentifierPropertyName();
                    Type idType = cmd.getIdentifierType();
                    JSONObject jo = new JSONObject();
                    jo.put("entity", entity);
                    jo.put("table", removeSchema(((AbstractEntityPersister) cmd).getTableName()));
                    jo.put("key", idName);
                    jo.put("type", idType.getName());
                    //去掉entity.
                    jo.put("collection", ja.getName().substring(entity.length() + 1));

                    CascadeStyle[] ccs = cmd.getPropertyCascadeStyles();
                    StringBuilder ccsOptions = new StringBuilder();
                    for (CascadeStyle cs : ccs) {
                        ccsOptions.append(",").append(cs);
                    }
                    jo.put("cascade", !ccsOptions.isEmpty() ? ccsOptions.substring(1).replace("STYLE_NONE,", "").replace("[", "").replace("]", "") : "");

                    String[] foreignKeys = ja.getKeyColumnNames();
                    jo.put("entity2", st.getAssociatedEntityName(sessionFactory));
                    jo.put("table2", removeSchema(ja.getTableName()));
                    //假定关联只有一个字段
                    jo.put("key2", foreignKeys[0]);
                    associations.put(jo);
                } else {
                    if (!(type instanceof ManyToOneType)) {
                        String columnName = ((AbstractEntityPersister) cmd).getPropertyColumnNames(property)[0];
                        JSONObject colJo = new JSONObject();
                        colJo.put("attr", property);
                        colJo.put("column", columnName);
                        colJo.put("type", type.getName());
                        columns.put(colJo);
                        joProperties.put(columnName, type.getName());
                    }
                }
            }
            // 添加id，id号没有当做属性获取
            String idName = cmd.getIdentifierPropertyName();
            Type idType = cmd.getIdentifierType();
            //记录主键
            JSONObject jp = new JSONObject();
            jp.put("id", idName);
            jp.put("type", idType.getName());
            joProperties.put("__primary__key__", jp);
            joProperties.put(idName, idType.getName());
            joProperties.put("__associations__", associations);
            result.put(entity, joProperties);
        }
        return result;
    }

    /**
     * remove schema
     *
     * @param tableName 表名
     * @return 处理后的表名
     */
    private String removeSchema(String tableName) {
        if (tableName.contains("."))
            return tableName.substring(tableName.indexOf('.') + 1);
        else {
            return tableName;
        }
    }
}
